/*
 * $Header: datefns.c,v 1.1 87/06/01 16:24:26 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	datefns.c,v $
 * Revision 1.1  87/06/01  16:24:26  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"
#ifdef BSD
/*
 * What is this, anyway?  Did UCB make localtime() a system call???
 * (If this is because of setitimer(), then WHY ARE setitimer() AND localtime()
 * IN THE SAME INCLUDE FILE?????)
 */
# include <sys/time.h>
#else
# include <time.h>
#endif

extern struct tm *localtime();

/*
 * Internal date manipulating functions.  They may be called by external
 * functions safely.
 */

/*
 * Return today's date in UNIFY(r) internal format.
 */

short _dt_today() {
	long now;
	struct tm *tmbuf;
	int date[3];

	now = time((long *) 0);
	tmbuf = localtime(&now);
	date[MONTH] = tmbuf->tm_mon + 1;
	date[DAY] = tmbuf->tm_mday;
	date[YEAR] = tmbuf->tm_year;
	return kday(date);
}

/*
 * Return the current year.
 */

int _dt_year() {
	long now;
	struct tm *tmbuf;

	now = time((long *) 0);
	tmbuf = localtime(&now);
	return tmbuf->tm_year;
}
