/*
 * $Header: clr_crt.c,v 1.2 87/04/29 11:30:12 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	clr_crt.c,v $
 * Revision 1.2  87/04/29  11:30:12  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  clr_crt() -- clear, forcibly, a screen on a given fd.
 *
 * DIFFERENCE FROM UNIFY:  If fd isn't 1, you get a run-time error; use the
 * old library if you want funny terminal stuff, or else hook into terminfo-
 * based curses and call newterm().  I daresay nobody uses the fd hook anyway.
 */

void clr_crt(fd, flg) {
	if (fd != 1)
		xerror(-1, "clr_crt", "Multi-terminal operation on fd %d not supported", fd);
	if (flg == 'a')
		(void) clear();
	else
		erasprmp(0, __nsf - 1);
}
