/*
 * $Header: yorn.c,v 1.5 87/06/01 11:26:32 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	yorn.c,v $
 * Revision 1.5  87/06/01  11:26:32  brandon
 * After adding code to save the upshift state, I forgot to assign the new
 * state.  (oops :-)
 * 
 * Revision 1.4  87/06/01  11:15:46  brandon
 * Smartened up response and cleared prompt before returning
 * 
 * Revision 1.3  87/05/26  13:34:48  brandon
 * Uses update mode with default = 'N'.
 * 
 * Revision 1.2  87/04/29  11:31:30  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  yorn() -- Ask for confirmation of an operation
 *
 * DIFFERENCE FROM UNIFY:  None.
 */

yorn(prompt)
char *prompt; {
	char ib[1];
	int oucf, ier;

	setraw();
	(void) mvaddstr(22, 1, prompt);
	for (;;) {
		ib[0] = 'N';
		oucf = _sh_up;
		_sh_up = 1;
		ier = inl(ib, 1, 0);
		_sh_up = oucf;
		switch (ier) {
		case FWD_OK:
			break;
		case BACK:
		case BACK_OK:
		case GO:
		case GO_OK:
		case FWD:
			ib[0] = 'N';
		}
		switch (ib[0]) {
		case 'Y':
		case 'y':
			(void) move(22, 1);
			(void) clrtoeol();
			return 1;
		case 'N':
		case 'n':
			(void) move(22, 1);
			(void) clrtoeol();
			return 0;
		}
		prtmsg(1, 23, "Please enter Y or N");
	}
}
