/*
 * $Header: utime.c,v 1.5 87/06/09 11:53:19 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	utime.c,v $
 * Revision 1.5  87/06/09  11:53:19  brandon
 * Right-justified buffer display; repositioned cursor after conversion errors.
 * 
 * Revision 1.4  87/06/01  08:37:49  brandon
 * Added ^V (view) capability for related records.
 * 
 * Revision 1.3  87/05/27  14:43:30  brandon
 * Made sure buffer was padded with spaces.
 * 
 * Revision 1.2  87/05/26  14:29:40  brandon
 * Well, utime() was the culprit (be nice if I could read!)-:
 * 
 * Revision 1.1  87/05/26  13:34:36  brandon
 * Initial revision
 * 
 * Revision 1.4  87/05/12  13:26:31  brandon
 * Dumb bug in : parsing.
 * 
 * Revision 1.3  87/05/12  12:04:10  brandon
 * Changed to pass FWD, BACK, GO without checking the data buffer
 * 
 * Revision 1.2  87/04/29  11:30:53  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * Get a time.  H:M only.
 */

int updtime(buf)
short *buf; {
	int cnt, rc, hr, min, y, x;
	char ibuf[6];

	setraw();
	(void) sprintf(ibuf, "%02d:%02d", *buf / 60, *buf % 60);
	getyx(stdscr, y, x);
	for (;;) {
		(void) move(y, x);
		if ((rc = inl(ibuf, 5, 0)) == BACK || rc == FWD || rc == GO || rc == LOOK)
			return rc;
		for (cnt = 0; cnt < 5 && ibuf[cnt] == ' '; cnt++)
			;
		if (cnt == 5) {
			prtmsg(1, 23, "Invalid time");
			continue;
		}
		if (!isdigit(cnt)) {
			prtmsg(1, 23, "Invalid time");
			continue;
		}
		hr = 0;
		min = 0;
		while (cnt < 5 && isdigit(ibuf[cnt])) {
			hr *= 10;
			hr += ibuf[cnt++] - '0';
		}
		if (cnt > 2 || ibuf[cnt++] != ':') {
			prtmsg(1, 23, "Invalid time");
			continue;
		}
		if (!isdigit(ibuf[cnt])) {
			prtmsg(1, 23, "Invalid time");
			continue;
		}
		min = 10 * (ibuf[cnt++] - '0');
		if (!isdigit(ibuf[cnt])) {
			prtmsg(1, 23, "Invalid time");
			continue;
		}
		min += ibuf[cnt++] - '0';
		while (cnt < 5)
			if (ibuf[cnt++] != ' ') {
				prtmsg(1, 23, "Invalid time");
				continue;
			}
		if (hr < 23 && min < 59)
			break;
		prtmsg(1, 23, "Invalid time");
	}
	return rc;
}
