/*
 * $Header: ustr.c,v 1.4 87/06/09 11:38:17 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	ustr.c,v $
 * Revision 1.4  87/06/09  11:38:17  brandon
 * Changed inl() call to use clrf == 2.
 * 
 * Revision 1.3  87/06/01  11:36:44  brandon
 * Was filling nulls[] instead of buf[]... dumb dumb da dumb :-)
 * 
 * Revision 1.2  87/06/01  11:23:53  brandon
 * UNIFY defaults STRNG fields to nulls (!) -- rather antisocial of it.  We
 * convert to spaces on update of an all-nulls STRNG field.
 * 
 * Revision 1.1  87/05/26  13:34:28  brandon
 * Initial revision
 * 
 * Revision 1.2  87/04/29  11:30:50  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * Get a string.  Very easy, since no checking is needed.  Except... UNIFY
 * defaults string fields to nulls (!) so we should check for all nulls and
 * convert to all spaces.  (Rather rude, in my opinion.)
 */

static char nulls[256];
static int _init = 0;

int ustr(len, buf)
char *buf; {
	setraw();
	if (!_init) {
		cfill(0, nulls, sizeof nulls);
		_init = 1;
	}
	if (ivcmp(buf, nulls, len))
		cfill(' ', buf, len);
	return inl(buf, len, 2);
}
