/*
 * $Header: upfield.c,v 1.1 87/05/26 13:50:09 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	upfield.c,v $
 * Revision 1.1  87/05/26  13:50:09  brandon
 * Initial revision
 * 
 * Revision 1.3  87/04/29  11:44:40  brandon
 * Added _UCF upshifting.  See also inbuf.c, xsfldesc.c.  (The comment in
 * inbuf.c is WRONG!)
 * Also caused error on screen field w/o database field.
 * 
 * Revision 1.2  87/04/29  11:30:44  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  upfield() -- Updata a database field using a screen field.
 *
 * DIFFERENCE FROM UNIFY:  UNIFY(r) does not provide update functions.
 */

upfield(sfld) {
	int rc, ousf;

	if (sfld < 0 || sfld >= __nsf)
		xerror(-1, "upfield", "Invalid screen field %d", sfld);
	if (__scf[sfld].q_fld == 0)
		xerror(-2, "upfield", "Screen field %d has no associated database field", sfld);
	ousf = _sh_up;
	_sh_up = __scf[sfld].q_type & _UCF;
	rc = updata(__scf[sfld].q_fx, __scf[sfld].q_fy, __scf[sfld].q_fld);
	_sh_up = ousf;
	return rc;
}
