/*
 * $Header: prmpf.c,v 1.2 87/04/29 11:31:12 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	prmpf.c,v $
 * Revision 1.2  87/04/29  11:31:12  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  prmpf() -- Display a string in the foreground
 *
 * DIFFERENCE FROM UNIFY:  Rather than dim/normal, uses regular output vs.
 * data fields underlined (if supported).  Note that cleancrt() won't undo
 * these, unfortunately.
 */

void prmpf(x, y, str)
char *str; {
	(void) attron(A_UNDERLINE);
	(void) mvaddstr(y, x, str);
	(void) attroff(A_UNDERLINE);
}
