/*
 * $Header: pflt.c,v 1.2 87/04/29 14:41:32 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	pflt.c,v $
 * Revision 1.2  87/04/29  14:41:32  brandon
 * Forgot to declare pflt() as (void)!
 * 
 * Revision 1.1  87/04/29  12:36:23  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * Display a value of type FLT.  Note that there is a problem here -- screen
 * fields come with # of decimals, database fields and outscrf() specs do not.
 * This problem persists and I don't know what, really, to do about it in the
 * case of database fields.  Screen fields get their specified decimals,
 * however, and outscrf() uses %g to avoid the issue entirely.  So dbfields
 * use outscrf() and you have to accept the loss.
 *
 * This is a botch.  UNIFY Corporation, PLEASE FIX THIS!!!  I don't like the
 * loss of this data and I don't like violating license agreements to dig it
 * out of the guts of UNITRIEVE!
 */

void pflt(len, buf, ndec)
double *buf; {
	(void) setraw();
	(void) attron(A_UNDERLINE);
	if (ndec == -1)	/* unknown decimals */
		(void) printw("%*g", len, *buf);
	else
		(void) printw("%*.*f", len, ndec, *buf);
	(void) attroff(A_UNDERLINE);
}
