/*
 * $Header: output.c,v 1.1 87/04/29 14:23:38 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	output.c,v $
 * Revision 1.1  87/04/29  14:23:38  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  output() -- Output data from the database to a screen field
 *
 * DIFFERENCE FROM UNIFY:  See outbuf() and pflt().
 */

void output(sfld) {
	int len;
	char buf[256];

	if (sfld < 0 || sfld >= __nsf)
		xerror(-1, "output", "Unknown screen field %d", sfld);
	if (__scf[sfld].q_fld == 0)
		xerror(-2, "output", "Screen field %d has no associated database field", sfld);
	if (gfield(__scf[sfld].q_fld, buf) != 0)
		xerror(-3, "output", "Read access for field %d denied", __scf[sfld].q_fld);
	len = __scf[sfld].q_len;
	switch (__scf[sfld].q_type) {
	case INT:
	case LONG:
	case STRNG:
		break;
	case AMT:
	case HAMT:
		len += 3;
		break;
	case DATE:
		len = 8;
		break;
	case HR:
		len = 5;
		break;
	case FLT:
		(void) move(__scf[sfld].q_fy, __scf[sfld].q_fx);
		pflt(__scf[sfld].q_len / 10, (double *) buf, __scf[sfld].q_len % 10);
		return;
	}
	outscrf(__scf[sfld].q_fx, __scf[sfld].q_fy, __scf[sfld].q_type & ~_UCF, len, buf);
}
