/*
 * $Header: outbuf.c,v 1.1 87/04/29 14:17:40 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	outbuf.c,v $
 * Revision 1.1  87/04/29  14:17:40  brandon
 * Initial revision
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  outbuf() -- Display data from a buffer to a screen field.
 *
 * DIFFERENCE FROM UNIFY:  None, since screen fields retain decimal info.
 */

void outbuf(sfld, buf)
char *buf; {
	int len;

	if (sfld < 0 || sfld >= __nsf)
		xerror(-1, "outbuf", "Unknown screen field %d", sfld);
	len = __scf[sfld].q_len;
	switch (__scf[sfld].q_type) {
	case INT:
	case LONG:
	case STRNG:
		break;
	case AMT:
	case HAMT:
		len += 3;
		break;
	case DATE:
		len = 8;
		break;
	case HR:
		len = 5;
		break;
	case FLT:
		(void) move(__scf[sfld].q_fy, __scf[sfld].q_fx);
		pflt(__scf[sfld].q_len / 10, (double *) buf, __scf[sfld].q_len % 10);
		return;
	}
	outscrf(__scf[sfld].q_fx, __scf[sfld].q_fy, __scf[sfld].q_type & ~_UCF, len, buf);
}
