/*
 * $Header: inl.c,v 1.15 87/06/09 11:37:10 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	inl.c,v $
 * Revision 1.15  87/06/09  11:37:10  brandon
 * New interpretation of clrf flag:  val 0 = clear if first char typed is text,
 * val 1 == clear on entry, val 2 = clear never.
 * 
 * Revision 1.14  87/06/01  16:29:24  brandon
 * Moved shellout() to shellout.c with a new name, so as not to duplicate code
 * in inc.c.
 * 
 * Revision 1.13  87/06/01  15:57:34  brandon
 * Cleaned up ^X; added underline-disable to ^V.
 * 
 * Revision 1.12  87/06/01  08:30:14  brandon
 * Added ^V (view) capability for related records.
 * 
 * Revision 1.11  87/05/28  14:03:17  brandon
 * Added ^V (view aka LOOK) for automatic explicit relationship chaining.
 * 
 * Revision 1.10  87/05/28  13:36:13  brandon
 * Logic of new-vs.-update and ^M input was wrong.
 * 
 * Revision 1.9  87/05/26  14:28:44  brandon
 * Added (void) casts for tty mode changes.
 * 
 * Revision 1.8  87/05/26  13:31:55  brandon
 * Added flag so that all updates return action code (*_OK).
 * 
 * Revision 1.7  87/05/26  11:18:59  brandon
 * Added clrf flag for update functions.
 * 
 * Revision 1.6  87/05/12  14:27:04  brandon
 * fixed final (!) insert bug
 * 
 * Revision 1.5  87/05/12  11:53:23  brandon
 * Now keeps original screen contents until the first modifying character is
 * typed, so the screen result of an initial BACK makes sense.
 * Changed code to determine whether a key is an action or an entry action
 * based on whether the buffer is empty or not AND the current cursor position;
 * this is now roughly compatible with ENTER.
 * 
 * Revision 1.4  87/05/12  11:38:24  brandon
 * Fixed job-control terminal settings.
 * Fixed "open" bug.
 * 
 * Revision 1.3  87/05/12  11:27:31  brandon
 * The "insert" and "delete" keys were swapped (!)
 * The shellout wasn't restoring line mode.  (It still doesn't, for job control
 * shells.)
 * 
 * Revision 1.2  87/04/29  11:30:42  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"
#include <signal.h>

/* setxrc() changes this, if nonzero then extended returns are enabled */
int __ext_rcodes = 0;

/*
 * Move to a specified location.  Wrap to the next line if necessary.
 */

static void moveto(y, x) {
	while (x >= COLS) {
		x -= COLS;
		if (++y == LINES)
			y--;
	}
	(void) move(y, x);
}

/*
 * Check to see if the input buffer is all spaces.  If so and the cursor is
 * at position zero, the action is a no-check (FWD, BACK, or GO) and the
 * returned buffer will not be processed.
 */

static int allspace(b, l)
register char *b;
register int l; {
	while (l-- > 0)
		if (*b++ != ' ')
			return 0;
	return 1;
}

/*
 * Input primitive.  Get a line of input.  If _sh_up is nonzero, shift to
 * uppercase.  Underline is used (when available) in place of foreground/
 * background stuff that curses doesn't grok anyway.
 *
 * Note that this is FAR smarter than the UNIFY version, including line editing
 * commands (insert/delete character, cursor motion, etc.).  This falls into
 * the category of ``why curses is better''.
 *
 * The `clrf' flag specifies whether the buffer is cleared or not prior to
 * input.  This is used by the USC-specific u* functions (update buffer).
 * If it is a value of 2, the buffer is never cleared except by ^K; otherwise
 * if it is 0, it is cleared if the first character typed is a text character.
 * If it is 1, the buffer is always cleared on entry.
 */

int inl(buf, len, clrf)
char *buf;
int len, clrf; {
	int y, x, cnt, ch, tmp, firsttime;

	setraw();
	(void) attron(A_UNDERLINE);
	if (clrf == 1)
		cfill(' ', buf, len);
	getyx(stdscr, y, x);
	cnt = 0;
	firsttime = 1;
	for (;;) {
		(void) move(y, x);
		if (!firsttime || clrf != 1) {
			(void) printw("%.*s", len, buf);
			moveto(y, x + cnt);
		}
		(void) refresh();
		ch = getchar() & 0x7f;
		switch (ch) {
		case '\033':
		case '\005':
			if (!(__ext_rcodes & XRC_GO)) {
				(void) beep();
				break;
			}
			(void) attroff(A_UNDERLINE);
			return ((__ext_rcodes & XRC_XOK) && (clrf != 1 || !allspace(buf, len) || cnt != 0)? GO_OK: GO);
		case '\t':
		case '\025':
			(void) attroff(A_UNDERLINE);
			return ((__ext_rcodes & XRC_XOK) && (clrf != 1 || !allspace(buf, len) || cnt != 0)? BACK_OK: BACK);
		case '\n':
		case '\r':
			(void) attroff(A_UNDERLINE);
			return (clrf == 1 && (allspace(buf, len) && cnt == 0)? FWD: FWD_OK);
		case '\b':
			if (cnt == 0)
				(void) beep();
			else {
				for (tmp = --cnt; tmp < len - 1; tmp++)
					buf[tmp] = buf[tmp + 1];
				buf[len - 1] = ' ';
			}
			break;
		case '\006':
			if (++cnt > len)
				cnt = 0;
			break;
		case '\002':
			if (--cnt < 0)
				cnt = len;
			break;
		case '\001':
			cnt = 0;
			break;
		case '\016':
			cnt = len;
			break;
		case '\017':
			for (tmp = len - 1; tmp > cnt; tmp--)
				buf[tmp] = buf[tmp - 1];
			buf[cnt] = ' ';
			break;
		case '\004':
			for (tmp = cnt; tmp < len - 1; tmp++)
				buf[tmp] = buf[tmp + 1];
			buf[len - 1] = ' ';
			break;
		case '\026':
			if (__ext_rcodes & XRC_LOOK) {
				(void) attroff(A_UNDERLINE);
				return LOOK;
			}
			(void) beep();
			break;
		case '\030':
			(void) move(LINES - 1, 0);
			(void) clrtoeol();
			(void) refresh();
			(void) endwin();
			exit(0);
		case '\013':
			cfill(' ', buf + cnt, len - cnt);
			break;
		case '\020':
			_inlsusp();
			break;
		case '\f':
		case '\022':
			(void) clearok(curscr);
			(void) wrefresh(curscr);
			break;
		default:
			if (cnt == len || ch < ' ' || ch == '\177') {
				(void) beep();
				break;
			}
			if (firsttime && clrf == 0)
				cfill(' ', buf, len);
			buf[cnt++] = (_sh_up? toupper(ch): ch);
		}
		firsttime = 0;
	}
}
