/*
 * $Header: iamt.c,v 1.6 87/06/09 11:45:05 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	iamt.c,v $
 * Revision 1.6  87/06/09  11:45:05  brandon
 * Added code to relocate cursor after conversion error message.
 * 
 * Revision 1.5  87/06/01  08:29:50  brandon
 * Added ^V (view) capability for related records.
 * 
 * Revision 1.4  87/05/26  13:31:23  brandon
 * Changed for new inl() (forces no-update mode).
 * 
 * Revision 1.3  87/05/12  12:04:06  brandon
 * Changed to pass FWD, BACK, GO without checking the data buffer
 * 
 * Revision 1.2  87/04/29  11:30:31  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * Input a small amount, into a (long).
 */

int iamt(len, buf)
long *buf; {
	char ibuf[10];
	int rc, cnt, sign, dec, y, x;

	setraw();
	if (len > 10)
		len = 10;
	getyx(stdscr, y, x);
	for (;;) {
		(void) move(y, x);
		if ((rc = inl(ibuf, len, 1)) == BACK || rc == FWD || rc == GO || rc == LOOK)
			return rc;
		for (cnt = 0; cnt < len && ibuf[cnt] == ' '; cnt++)
			;
		if (cnt == len) {
			prtmsg(1, 23, "Invalid amount");
			continue;
		}
		*buf = 0L;
		sign = 0;
		dec = 0;
		if (ibuf[cnt] == '-') {
			sign = 1;
			if (++cnt == len) {
				prtmsg(1, 23, "Invalid amount");
				continue;
			}
		}
		for (; cnt < len && isdigit(ibuf[cnt]); cnt++) {
			*buf *= 10;
			*buf += ibuf[cnt] - '0';
		}
		if (ibuf[cnt] == '.') {
			if (cnt > len - 2) {
				prtmsg(1, 23, "Invalid amount");
				continue;
			}
			if (!isdigit(ibuf[++cnt])) {
				prtmsg(1, 23, "Invalid amount");
				continue;
			}
			dec = (ibuf[cnt] - '0') * 10;
			if (!isdigit(ibuf[++cnt])) {
				prtmsg(1, 23, "Invalid amount");
				continue;
			}
			dec += ibuf[cnt] - '0';
		}
		for (; cnt < len && ibuf[cnt] == ' '; cnt++)
			;
		if (cnt == len)
 			break;
		prtmsg(1, 23, "Invalid amount");
	}
	*buf = *buf * 100 + dec;
	if (sign)
		*buf = - *buf;
	return rc;
}
