/*
 * $Header: gtube.c,v 1.6 87/06/09 12:22:11 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	gtube.c,v $
 * Revision 1.6  87/06/09  12:22:11  brandon
 * Moved FYI message to line 23; cleared it after input.
 * 
 * Revision 1.5  87/06/01  08:29:28  brandon
 * Added ^V (view) capability for related records.
 * 
 * Revision 1.4  87/04/29  16:09:49  brandon
 * Added a cast to (void) of mvaddstr()
 * 
 * Revision 1.3  87/04/29  13:10:36  brandon
 * fldesc() returns display length, so mucking around with it isn't needed.
 * However, probably input() or inbuf() will need help...
 * 
 * Revision 1.2  87/04/29  11:30:28  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  gtube() -- Get input using a database field template.
 *
 * DIFFERENCE FROM UNIFY:  See inscrf().  Also, the UNIFY 3.2 manual says that
 * COMB fields are allowed in gtube(); they never were before.  I am assuming
 * that the manual is in error, since inputting a COMB field may be nice but
 * is extremely difficult and requires a search throuh every field in the
 * database, without the secret information internal to UNITRIEVE.  That, of
 * course, assumes that we're not treating it as type == STRNG, which would
 * be a *real* botch.
 *
 * Another major difference is that with XRC_LOOK enabled, ^V will cause a
 * browse screen for related records to pop up; select a record and press
 * GO (ESC) to enter that value.
 */

gtube(fx, fy, field, buf)
char *buf; {
	FLDESC fd;
	int rc;
#ifdef UNIFY32
	char *cmsg, *emsg;
#endif

	setraw();
	if (!fldesc(field, &fd))
		xerror(-1, "gtube", "Invalid field %d", field);
	if (fd.f_typ == COMB)
		xerror(-2, "gtube", "COMB field %d illegal", field);
#ifdef UNIFY32
	cmsg = getdoms(field, FYISTR);
	if ((emsg = getdoms(field, ERRSTR)) == (char *) 0)
		emsg = "The value you entered is not legal for this field";
	for (;;) {
		if (cmsg != (char *) 0)
			(void) mvaddstr(23, 1, cmsg);
#endif
		rc = inscrf(fx, fy, fd.f_typ, fd.f_len, buf);
#ifdef UNIFY32
		(void) move(23, 1);
		(void) clrtoeol();
#endif
		if (rc == BACK || rc == FWD || rc == GO)
			return rc;
		if (rc == LOOK) {
			if (fd.f_rpfld == 0) {
				prtmsg(1, 23, "There is no related record to view");
				continue;
			}
			if ((rc = zoom(fx, fy, field, &fd, buf)) == BACK || rc == FWD)
				return rc;
			outscrf(fx, fy, fd.f_typ, fd.f_len, buf);
		}
#ifdef UNIFY32
		if (domchk(field, buf))
			break;
		prtmsg(1, 23, emsg);
	}
#endif
	return rc;
}
