/*
 * $Header: erasprmp.c,v 1.2 87/04/29 11:30:24 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	erasprmp.c,v $
 * Revision 1.2  87/04/29  11:30:24  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  erasprmp() -- Clear the data portions of screen fields
 *
 * DIFFERENCES FROM UNIFY:  Since data fields are foreground, we enter
 * underline mode (if supported).
 */

void erasprmp(ssfld, esfld) {
	int len;

	(void) attron(A_UNDERLINE);
	for (; ssfld <= esfld; ssfld++) {
		if (ssfld < 0 || ssfld >= __nsf)
			xerror(-1, "erasprmp", "Invalid screen field %d", ssfld);
		if (__scf[ssfld].q_len == 0)
			continue;	/* no data field involved */
		len = __scf[ssfld].q_len;
		switch (__scf[ssfld].q_type) {
		case DATE:
			len = 8;
			break;
		case HR:
			len = 5;
			break;
		case FLT:
			len /= 10;
			break;
		case HAMT:
		case AMT:
			len += 3;
			break;
		}
		(void) mvprintw(__scf[ssfld].q_fy, __scf[ssfld].q_fx, "%*s", len, "");
	}
	(void) attroff(A_UNDERLINE);
}
