/*
 * $Header: eras_ln.c,v 1.2 87/04/29 11:30:22 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	eras_ln.c,v $
 * Revision 1.2  87/04/29  11:30:22  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

/*
 * ENTRY POINT:  eras_ln() -- clear, forcibly, a line on a given fd.
 *
 * DIFFERENCE FROM UNIFY:  If fd isn't 1, you get a run-time error; use the
 * old library if you want funny terminal stuff, or else hook into terminfo-
 * based curses and call newterm().  I daresay nobody uses the fd hook anyway.
 */

void eras_ln(fd) {
	if (fd != 1)
		xerror(-1, "eras_ln", "Multi-terminal operation on fd %d not supported", fd);
	(void) clrtoeol();
}
