/*
 * $Header: datetp.c,v 1.5 87/05/12 15:35:12 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	datetp.c,v $
 * Revision 1.5  87/05/12  15:35:12  brandon
 * langtp[] wasn't being set properly.
 * 
 * Revision 1.4  87/04/29  16:01:06  brandon
 * The #ifdef for UNIFY32 should have been an #ifndef.
 * 
 * Revision 1.3  87/04/29  12:20:40  brandon
 * Not only is DATETP not supported under pre-3.2 UNIFY, but parmnt tends to
 * dump core if you attempt to change it.
 * 
 * Revision 1.2  87/04/29  11:30:15  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

#ifndef UNIFY32

/* No real choice, unfortunately -- and parmnt dumps core if you try!  :-( */
int _ldbrt = UNITED_STATES | MDY;

#else

/*
 * Under UNIFY 3.2, the "langtp" variable becomes a means of changing the
 * parsing of dates, and also determines whether a bracket conforms to the
 * standards of the United States -- `[]' -- or to the rest of the world
 * -- `()'.  (As usual, the U.S. is oddball.  Kind of makes you wonder...)
 */

extern char langtp[2];
int _ldbrt = -1;

#define CH(x,y)		(((x) << 8) | (y))

void _sdbrt() {
	if (_ldbrt != -1)
		return;
	if (langtp[0] == '\0') {
		char *cp;

		if ((cp = getenv("DATETP")) == (char *) 0)
			cp = "EN";	/* UNIFY still has old default?! */
		langtp[0] = cp[0];
		langtp[1] = cp[1];
	}
	switch (CH(langtp[0], langtp[1])) {
	case CH('A', 'M'):
	case CH('E', 'N'):
		_ldbrt = UNITED_STATES | MDY;
		break;
	case CH('E', 'U'):
		_ldbrt = INTERNATIONAL | DMY;
		break;
	case CH('U', 'S'):
		_ldbrt = INTERNATIONAL | MDY;
		break;
	default:
		{
			char buf[3];
			buf[0] = langtp[0];
			buf[1] = langtp[1];
			buf[2] = '\0';
			prtmsg(1, 22, buf);
		}
		_ldbrt = INTERNATIONAL | YMD;
	}
}

#endif	/* UNIFY32 */
