/*
 * $Header: curses.c,v 1.2 87/04/29 11:30:14 brandon Exp $
 *
 * ``USC'' -- UNIFY(r) Screens using Curses
 * UNIFY(r) is a registered trademark of Unify Corporation.
 *
 * THIS PROGRAM IS NOT BASED ON COPYRIGHTED CODE OF UNIFY CORPORATION, AND
 * IS HEREBY PLACED IN THE PUBLIC DOMAIN.
 *
 * $Log:	curses.c,v $
 * Revision 1.2  87/04/29  11:30:14  brandon
 * Added RCS header information
 * 
 */

/*LINTLIBRARY*/

#include "usc.h"

#ifdef TERMCAP

/*
 * The old style curses doesn't know about attributes, except for standout.
 * We have to emulate them... which basically means ignoring them, except
 * for A_STANDOUT == A_REVERSE.
 */

int setattr(win, att)
WINDOW *win; {
	if (att == A_STANDOUT)
		return wstandout(win);
	else
		return wstandend(win);
}

int attron(win, att)
WINDOW *win; {
	if (att == A_STANDOUT)
		return wstandout(win);
	return OK;
}

int attroff(win, att)
WINDOW *win; {
	if (att == A_STANDOUT)
		return wstandend(win);
	return OK;
}

int flushinp() {
#ifdef TIOCGETP
	struct sgttyb t;

	if (ioctl(0, TIOCGETP, &t) == -1)
		return ERR;
	if (ioctl(0, TIOCSETP, &t) == -1)
		return ERR;
#else
# ifdef TCFLSH
	if (ioctl(0, TCFLSH, 0) == -1)
		return ERR;
# else
	struct sgttyb t;

	if (gtty(0, &t) == -1)
		return ERR;
	if (stty(0, &t) == -1)
		return ERR;
# endif
#endif
	return OK;
}

#else
# ifndef lint
static char dummy[] = "";	/* gratuitous dumb-loader food */
# endif
#endif
