/*****************************************************************************
*
* %W%   %G%   %U%
*
*   NAME:           to_upper
*   DESCRIPTION:    Accell/C-hook for converting a string to all upper case
*
*   ACCELL USAGE:   to_upper(string)
*                     where:
*                        string 			is a string value
*
*   AUTHOR:         Mark Hargrove
*   DATE:            7/30/87
*
*   Modification History:
*
******************************************************************************/
#include <chookincl.h>
#define YES 1
#define NO  0

int
to_upper(numargs, acclarg)
	int numargs;
	AVAL acclarg[];
{
	AVAL retval;
	register int i;

	/* set up for an error return condition */
	retval.aknd = A_INT; 
	retval.dfflg = YES;

	if (numargs != 2)
	{
		retval.aval.inval = 1;
		chookrt(&retval);
		return;
	}
	if (acclarg[0].dfflg == NO || acclarg[1].dfflg == NO)
	{
		retval.aval.inval = 2;
		chookrt(&retval);
		return;
	}
	if (acclarg[0].aknd != A_STR || acclarg[1].aknd != A_STR)
	{
		retval.aval.inval = 3;
		chookrt(&retval);
		return;
	}
	if (strlen(acclarg[0].aval.stval) > strlen(acclarg[1].aval.stval))
	{
		retval.aval.inval = 4;
		chookrt(&retval);
		return;
	}
	cfill('\0', acclarg[1].aval.stval, strlen(acclarg[1].aval.stval));
	for (i = 0; i < strlen(acclarg[0].aval.stval); i++)
		acclarg[1].aval.stval[i] = toupper(acclarg[0].aval.stval[i]);
		
	retval.aval.inval = 0;
	chookrt(&retval);
	return;
}
