/*
 *		Extended (M-X) commands.
 */
#include	"def.h"


/*
 * Extended command. Call the message line
 * routine to read in the command name and apply autocompletion
 * to it. When it comes back, look the name up in the symbol table
 * and run the command if it is found and has the right type.
 * Print an error if there is anything wrong.
 */
/*ARGSUSED*/
extend(f, n, k)
{
	register SYMBOL	*sp;
	register int	s;
	char		xname[NXNAME];

	if (f == FALSE)
		s = eread("M-x ", xname, NXNAME, EFNEW|EFFUNC
#ifndef VARARGS
			 , (char *) NULL
#endif
			 ) ;
	else
		s = eread("%d M-x ", xname, NXNAME, EFNEW|EFFUNC, 
#ifdef	VARARGS
			 n
#else
			 (char *) &n, (char *) NULL
#endif
			 ) ;
	if (s != TRUE) return (s);
	if ((sp=symlookup(xname)) != NULL)
		return ((*sp->s_funcp)(f, n, KRANDOM));
	ewprintf("[No match]");
	return FALSE;
}

/*
 * This function will erase the current buffer, re-read the file, and
 * cancel the modification flag. It has to remember the file name.
 */
/*ARGSUSED*/
startover( f, n, k)
{
	BUFFER *bp;

	bp = wheadp->w_bufp;
	if (bclear(bp) != FALSE)	/* user did not abort it */
	{
		insertfile( bp->b_fname, (char *)NULL);
		notmodified( FALSE, 0, KRANDOM);
		sgarbf = TRUE;
	}
}

/*
 * This function will quit Emacs without saving any files,
 * or asking about saving them. Just call quit with an argument.
 */
/*ARGSUSED*/
reallyquit( f, n, k)
{
	extern int quit();

	quit( TRUE, 1, KRANDOM);
}

/*
 * This function will delete the current line. It is easy because
 * all of the work is done in "killline". The cursor may be anywhere
 * on it, not just at the beginning.
 */
/*ARGSUSED*/
deleteline( f, n, k)
{
	killline( TRUE, 0, KRANDOM);	/* kill beginning of line */
	killline( TRUE, 1, KRANDOM);	/* kill end including nl */
}

#ifdef	STARTUP
/*
 * Define the commands needed to do startup-file processing.
 * This code is mostly a kludge just so we can get startup-file processing.
 *
 * If you're serious about having this code, you should rewrite it.
 * To wit: 
 *	It has lots of funny things in it to make the startup-file look
 *	like a GNU startup file; mostly dealing with parens and semicolons.
 *	This should all vanish.
 *
 *	It uses the same buffer as keyboard macros. The fix is easy (make
 *	a new function "execmacro" that takes a pointer to char and
 *	does what ctlxe does on it. Make ctlxe and excline both call it.)
 *	but would slow down the non-micro version.
 *
 * We define eval-expression because it's easy. It's pretty useless,
 * since it duplicates the functionality of execute-extended-command.
 * All of this is just to support startup files, and should be turned
 * off for micros.
 */

/*
 * evalexpr - get one line from the user, and run it. Identical in function
 *	to extend, but easy.
 */
/*ARGSUSED*/
evalexpr(f, n, k)
{
	register int	s;
	char		exbuf[NKBDM];

	if ((s = ereply("Eval: ", exbuf, NKBDM)) != TRUE)
		return s;
	return excline(exbuf);
}
/*
 * evalbuffer - evaluate the current buffer as line commands. Useful
 *	for testing startup files.
 */
/*ARGSUSED*/
evalbuffer(f, n, k)
{
	register LINE	*lp;
	register BUFFER	*bp = curbp;
	register int	s;
	static char	excbuf[NKBDM];
	char		*strncpy();

	for (lp = lforw(bp->b_linep); lp != bp->b_linep; lp = lforw(lp))
	{
		if (llength(lp) >= NKBDM + 1) return FALSE ;
		(VOID) strncpy(excbuf, ltext(lp), NKBDM);
		if ((s = excline(excbuf)) != TRUE) return s;
	}
	return TRUE;
}
/*
 * evalfile - go get a file and evaluate it as line commands. You can
 *	go get your own startup file if need be.
 */
/*ARGSUSED*/
evalfile(f, n, k)
{
	register int	s;
	char		fname[NFILEN];

	if ((s = ereply("Load file: ", fname, NFILEN)) != TRUE)
		return s;
	return load(fname);
}

/*
 * load - go load the file name we got passed.
 */
load(fname) char *fname;
{
	register int	s;
	char		excbuf[NKBDM];

	if (((s = ffropen(fname)) == FIOERR) || (s == FIOFNF))
		return FALSE;
	while ((s = ffgetline(excbuf, NKBDM)) == FIOSUC)
		if (excline(excbuf) != TRUE) break;
	(VOID) ffclose();
	return s == FIOEOF;
}

/*
 * excline - run a line from a load file or eval-expression.
 */
excline(line) register char *line;
{
	register char	*funcp, *argp = NULL;
	char		*skipwhite(), *parsetoken(), *backquote();
	int		status;

	/* Don't know if it works; don't care - mwm */
	if (kbdmip != NULL || kbdmop != NULL)
	{
		ewprintf("Not now!") ;
		return FALSE;
	}

	funcp = skipwhite(line);
	if (*funcp == '\0') return TRUE;	/* No error on blank lines */
	line = parsetoken(funcp);
	if (*line != '\0')
	{
		*line++ = '\0';
		line = skipwhite(line);
		if ((*line >= '0' && *line <= '9') || *line == '-')
		{
			argp = line;
			line = parsetoken(line);
		}
	}

	kbdmip = &kbdm[0];
	if (argp != NULL)
	{
		*kbdmip++ = (KEY) (KCTRL|'U');
		*kbdmip++ = (KEY) atoi(argp);
	}
	*kbdmip++ = (KEY) (KMETA|'X');
	/* Pack in function */
	while (*funcp != '\0')
		if (kbdmip+1 <= &kbdm[NKBDM-3])
			*kbdmip++ = (KEY) *funcp++;
		else
		{
			ewprintf("eval-expression macro overflow");
			ttflush();
			return FALSE;
		}
	*kbdmip++ = '\0';	/* done with function */
	/* Pack away all the args now...	*/
	while (*line != '\0')
	{
		argp = skipwhite(line);
		if (*argp == '\0') break ;
		line = parsetoken(argp) ;
		/* Slightly bogus for strings. But they should be SHORT! */
		if (kbdmip+(line-argp)+1 > &kbdm[NKBDM-3])
		{
			ewprintf("eval-expression macro overflow");
			ttflush();
			return FALSE;
		}
		if (*line != '\0') *line++ = '\0';
		if (*argp != '"')
		{
			if (*argp == '\'') ++argp;
			while (*argp != '\0')
				*kbdmip++ = (KEY) *argp++;
			*kbdmip++ = '\0';
		}
		else
		{	/* Quoted strings special again */
			++argp;
			while (*argp != '"' && *argp != '\0')
				if (*argp != '\\') *kbdmip++ = (KEY) *argp++;
				else argp = backquote(++argp, TRUE);
			/* Quotes strings are gotkey'ed, so no trailing null */
		}
	}
	*kbdmip++ = (KEY) (KCTLX|')');
	*kbdmip++ = '\0';
	kbdmip = NULL;
	status = ctlxe(FALSE, 1, KRANDOM);
	kbdm[0] = (KCTLX|')');
	return status;
}
/*
 * a pair of utility functions for the above
 */
char *
skipwhite(s) register char *s;
{

	while ((*s == ' ' || *s == '\t' || *s == ')' || *s == '(')
	    && *s != '\0')
		if (*s == ';') *s = '\0' ;
		else s++;
	return s;
}

char *
parsetoken(s) register char *s;
{

	if (*s != '"')
		while (*s != ' ' && *s != '\t' && *s != '(' && *s != ')'
				&& *s != '\0')
		{
			if (*s == ';')
				*s = '\0';
			else
				s++;
		}
	else	/* Strings get special treatment */
		do {
			/* Beware: You can \ out the end of the string! */
			if (*s == '\\')
				++s;
			if (ISLOWER(*s))
				*s = TOUPPER(*s);
			} while (*++s != '"' && *s != '\0');
	return s;
}
/*
 * Put a backquoted string element into the keyboard macro. Return pointer
 * to char following backquoted stuff.
 */
/* Don't want to get the objects in isdigit.c just for this */
#define	isdigit(c)	(((c) >= '0') && ((c) <= '9'))

char *
backquote(in, flag) char *in;
{
	register KEY	keycode;

	switch (*in++)
	{
	    case 'T': *kbdmip++ = (KEY) (KCTRL|'I');
		      break;
	    case 'N': *kbdmip++ = (KEY) (KCTRL|'J');
		      break; 
	    case 'R': *kbdmip++ = (KEY) (KCTRL|'M');
		      break;
	    case '^': *kbdmip = (KEY) (KCTRL|*in++);
		if (flag != FALSE && *kbdmip == (KEY) (KCTRL|'X'))
		{
			if (*in == '\\')
				in = backquote(++in, FALSE);
			else
				*kbdmip++ = (KEY) *in++;
			kbdmip[-1] |= (KEY) KCTLX;
		}
		else ++kbdmip;
		      break;
	    case 'E':
		if (flag != TRUE)
			*kbdmip++ = (KEY) (KCTRL|'[');
		else if (*in != '\\')
			*kbdmip++ = (KEY) (KMETA|*in++);
		else
		{
			in = backquote(++in, FALSE);
			kbdmip[-1] |= (KEY) KMETA;
		}
		break;

	    /* (L. Frenkel) Convert "\Fd" and "\Fdd" to a function
	     * key code between KFIRST and KLAST. "dd" should be
	     * decimal; codes > KLAST are mapped to KLAST, for want
	     * of a better idea of what to do with them.
	     */
	    case 'F':
		keycode = 0;
		if (isdigit(*in))
			keycode += *in++ - '0';
		if (isdigit(*in))
			keycode = (10 * keycode) + *in++ - '0';
		if ( (keycode += KFIRST) > KLAST)
			keycode = KLAST;
		*kbdmip++ = (KEY) keycode;
		break;
	}
	return in;
}
#endif	STARTUP
