/*****************************************************************************
*
* %W%   %G%   %U%
*
*   NAME:           display_txt
*   DESCRIPTION:    Accell/C-hook for displaying a text field
*
*   ACCELL USAGE:   display_txt(target_variable, screen_variable)
*                     where:
*                        target_variable is the long name of
*                                        a UNIFY database field
*                        screen_variable is an ACCELL screen variable
*                                        which MUST be pre-initialized
*                                        to be at least as long as the
*                                        display length of the text field.
*                        
*
*   AUTHOR:         Mark Hargrove
*   DATE:            7/17/87
*
*   Modification History:
*
******************************************************************************/
#include <chookincl.h>
#define YES 1
#define NO  0

int
display_txt(numargs, acclarg)
	int numargs;
	AVAL acclarg[];
{
	char *field_name, *screen_field;
	int rc, field_number, screen_field_width;
	AVAL retval;

	/* set up for an error return condition */
	retval.aknd = A_INT; 
	retval.dfflg = YES;

	if (numargs != 2)
	{
		retval.aval.inval = 1;
		chookrt(&retval);
		return;
	}
	if (acclarg[0].dfflg == NO || acclarg[1].dfflg == NO)
	{
		retval.aval.inval = 2;
		chookrt(&retval);
		return;
	}

	field_name = acclarg[0].aval.stval;
	screen_field = acclarg[1].aval.stval;

	if ((field_number = get_fld_num(field_name)) < 0)
	{
		retval.aval.inval = 3;
		chookrt(&retval);
		return;
	}

	if ((rc = get_txt_hd(screen_field, field_number)) != 0)
	{
		retval.aval.inval = 4;
		chookrt(&retval);
		return;
	}
	retval.aval.inval = 0;
	chookrt(&retval);
	return;
}
