/******************************************************************************
*  PROGRAM    :  week_day
*  DESCRIPTION:  returns the day of the week given the current date
*
*  AUTHOR     :  Scott Henry    
*  DATE       :  11/18/87  
******************************************************************************/
#include <time.h>
#include <stdio.h>
#include <chookincl.h>
#define YES 1
#define NO  0
extern int errno;
static char *RCSid = "$Header: week_day.c,v 1.2 88/01/20 16:29:47 root Exp $";

int
week_day(numargs, acclarg)		/* returns 0 = Sunday, 6 = Saturday */
	int numargs;
	AVAL acclarg[];
{
	AVAL	retval;
	long	clock, time();
	struct	tm *timex;

	/* set up for an error return */
	retval.aknd  = A_INT;
	retval.dfflg = YES;
	retval.aval.inval = 0;

	if (numargs == 0)
	{				/* day-of-week based on system clock */
		clock = time((long *)0);
		timex = localtime(&clock);
		retval.aval.inval = timex->tm_wday;
	}
	chookrt(&retval);
	return;
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/

int
day_of_week( numarg, acclarg)
   int numarg;
   AVAL acclarg[];
{
	AVAL	retval;
	long	udate;

	/* set up for an error return */
	retval.aknd  = A_INT;
	retval.dfflg = YES;
	retval.aval.inval = 0;

	if (numarg == 1 && acclarg[0].dfflg == YES && acclarg[0].aknd == A_DATE)
	{				/* day-of-week based on input date */
		udate = acclarg[0].aval.daval;
		retval.aval.inval = (udate + 32764L) % 7;
	}

	chookrt(&retval);
	return;
}

/*=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
$Log:	week_day.c,v $
 * Revision 1.2  88/01/20  16:29:47  root
 * baseline before code changes to workaround .dbv bug
 * 
 * Revision 1.1  87/11/18  12:19:31  scotth
 * Initial revision
 * 
=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/
