/*****************************************************************************
*
* %W%   %G%   %U%
*
*   NAME:           text_size
*   DESCRIPTION:    Accell/C-hook for determining actual size of a text field
*
*   ACCELL USAGE:   text_size(target_variable)
*                     where:
*                        target_variable is the long name of
*                                        a UNIFY database field
*
*   AUTHOR:         Mark Hargrove
*   DATE:           8/25/87
*
*   RETURNS:
*		 size of text on successul return
*      < 0 on error return
*
******************************************************************************/
#include "fdesc.h"
#include "chookincl.h"
#include "dbtypes.h"
#include "domains.h"
#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#define YES   1
#define NO   0

extern int get_fld_num();

int   
text_size(numargs, acclarg)
   int numargs;
   AVAL acclarg[];
{
   AVAL retval;
   char *field_name;  /* long name of database field */
   int fld;            /* field number */
   long txt_size;   /* Actual size of text in DB */
   int   rc;         /* Return code */
   FIELDLIST flist;   /* Data transfer descriptor block for gfield and pfield */
   FLDESC fdsc;      /* Data base field descriptor */
   char errbuf[256];  /* For output messages */

   /* set up for an error return condition */
   retval.aknd = A_INT; 
   retval.dfflg = YES;

   if (numargs != 1)
   {
      retval.aval.inval = -1;
      chookrt(&retval);
      return;
   }
   if (acclarg[0].dfflg == NO)
   {
      retval.aval.inval = -2;
      chookrt(&retval);
      return;
   }

   field_name = acclarg[0].aval.stval;

   if ((fld = get_fld_num(field_name)) < 0)
   {
      retval.aval.inval = -3;
      chookrt(&retval);
      return;
   }

   /* Check for valid field type */
   if ((rc = fldesc( fld, &fdsc )) != 1)
   {
      sprintf(errbuf,"txt_size: got bad field=%d",fld);
      prtmsg(0,22,errbuf);
      retval.aval.inval = -4;
      chookrt(&retval);
      return;
   }

   if ((rc = fdsc.f_typ) != TEXT )
   {
      sprintf(errbuf,"txt_size: got non-TEXT field=%d",fld);
      prtmsg(0,22,errbuf);
      retval.aval.inval = -5;
      chookrt(&retval);
      return;
   }

   /* Get size of actual text in database */
   if ((rc = gsize(fld, &txt_size)) != 0)
   {
      sprintf(errbuf,"text_size: can't retrieve gsize for field=%d",fld);
      prtmsg(0,22,errbuf);
      retval.aval.inval = -6;
      chookrt(&retval);
      return;
   }
	retval.aval.inval = txt_size;
	chookrt(&retval);
	return;
}
