/*
 * Name:	MicroEMACS
 *		Spawn CLI for System V.
 * Version:	0
 * Last edit:	17-Apr-86
 * By:		gonzo!daveb
 *		{sun, amdahl, mtxinu}!rtech!daveb
 *
 * Spawn for System V.
 */
#include	"def.h"

#include	<signal.h>
#include	<stdio.h>

extern	char	*getenv();

/*
 * Execute a single command using the shell. If no argument,
 * then print the file in the top (only) buffer, after making
 * sure that it has been flushed to disk.
 */
/*ARGSUSED*/
spawncmd( f, n, k)
   int f, n;
   char **k;
{
   char cmdbuf[80];
   extern char *getenv();
   register int   pid;
   register int   wpid;
   int   (*oqsig)();
   int   (*oisig)();
   int      status;
   int      errp = FALSE;

   if (f == FALSE)      /* no command provided */
   {
      char *printcmd;
      char *argv[32];
      char argbuf[128];
      char *ptr;
      int argc;

      (void)memset(argbuf, 0, 128);
      if ((printcmd = getenv("SPOOLER")) == NULL)
         printcmd = "lp -s";
      (void)strcpy( argbuf, printcmd);
#ifdef DEBUG
	fprintf(stderr, "spooler='%s'\n", argbuf);
#endif
      for (argc=0, ptr=argbuf; *ptr; )
      {
         while (*ptr && (*ptr == ' ' || *ptr == '\t'))
	   {
	     *ptr++ = '\0';
	   }
         argv[argc++] = ptr;
         while (*ptr && *ptr != ' ' && *ptr != '\t')
            ++ptr;
      }
      if (argv[argc-1][0] == '\0')
         argv[argc-1] = NULL;
      argv[argc] = NULL;
#ifdef DEBUG
	{
	int i;
		fprintf(stderr, "argc=%d,", argc);
		fprintf(stderr, " argv='%s'", argv[0]);
		for (i=1; i<=argc; ++i)
		   fprintf(stderr, ",'%s'", argv[i]);
		fprintf(stderr, "\n");
	}
#endif
      (void)strcpy( cmdbuf, wheadp->w_bufp->b_fname);

      ewprintf("Please Wait...");
      oqsig = signal(SIGQUIT, SIG_IGN);
      oisig = signal(SIGINT,  SIG_IGN);
      if ((pid=fork()) == 0)
      {
         freopen( cmdbuf, "r", stdin);
         execvp( argv[0], argv);
         _exit(1);         /* Should do better!   */
      }
      else if (pid > 0)
      {
         while ((wpid=wait(&status))>=0 && wpid!=pid)
            ;
      }
      else
         errp = TRUE;

      signal(SIGQUIT, oqsig);
      signal(SIGINT,  oisig);
      if(errp)
         ewprintf("Print failed (can't create process).");
      else if (status)
         ewprintf("spooler returned error status=%d", status);
      else
         ewprintf("Text Queued for print");
   }
   else
   {
      /*
       * Don't do nuthin currently
       */
   }
   return TRUE;
}

#ifdef MENU_INSERT
/*
 * Menu Insert -- spawn a shell with the menu shell script
 */
spawninsert( f, n, k)
{
   extern char   *strrchr(), *strcpy(), *strcat(), *tmpnam();
   register int   pid;
   register int   wpid;
   register int   (*oqsig)();
   register int   (*oisig)();
   int      status;
   int      errp = FALSE;
   char      menup[80], *menuname = NULL;
   char      tempfile[L_tmpnam];

   (void)strcpy( menup, getenv("DBBIN"));
   if (menup[strlen(menup)-1] != '/')
      (void)strcat( menup, "/");
   if ((menuname = getenv("EMENU")) == NULL)
   {
      menuname = "mgx-menu.sh";
   }
   (void)strcat(menup, menuname);
   menuname = strrchr( menup, '/' ); 
   menuname = menuname ? menuname++ : menup;

   strcpy (tempfile, tmpnam((char *)0));
   ttcolor(CTEXT);
   ttnowindow();
   ttmove(nrow-1, 0);
   if (epresf != FALSE)
   {
      tteeol();
      epresf = FALSE;
   }
   ttclose();
   sgarbf = TRUE;            /* Force repaint.   */
   oqsig = signal(SIGQUIT, SIG_IGN);
   oisig = signal(SIGINT,  SIG_IGN);
   if ((pid=fork()) == 0)
   {
      execlp(menup, menuname, tempfile, NULL);
      _exit(1);         /* Should do better!   */
   }
   else if (pid > 0)
   {
      while ((wpid=wait(&status))>=0 && wpid!=pid)
         ;
   }
   else
      errp = TRUE;

   signal(SIGINT,  oisig);
   ttopen();
   if(errp)
      ewprintf("Failed to create process");
   else
   {
      gotobol( FALSE, 0, 0);
      insertfile( tempfile, (char *)0);
   }
   unlink( tempfile);
   return ( errp | status );
}
#endif
