#include <stdio.h>
/*
get_fld_num()   --  gets field number from short field name (or long name)

USAGE:
    int	  field	     
    char *string_ptr    Points to name of desired field 

    field = get_fld_num( string_ptr );

NOTES:
	returns zero if name not recognized 
*/
char *fldname();
char *fldsyn();

/*-------------------------------------------------------------*/
int 	get_fld_num( s_ptr )
char *s_ptr;
{
int  max_field;	/* Highest field index in use in system */
int  fld;			/* Counter */
char *t_ptr; 		/* temp. string pointer */
	
	/*----------------------------------------------------------*/
	/* Find out how many fields are in the database */
	max_field = numflds();
	
	/*----------------------------------------------------------*/
	/* Try all short database names looking for a match */
	for (fld=1; fld<=max_field; fld++ )
	{
		if ( (t_ptr=fldsyn(fld)) != NULL )
		{
			if ( strcmp( s_ptr, t_ptr ) == 0 )	
			{
				return( fld );
			}
		}
		
	}

	/*----------------------------------------------------------*/
	/* Try all long database names looking for a match */
	for (fld=1; fld<=max_field; fld++ )
	{
		if ( (t_ptr=fldname(fld)) != NULL )
		{
			if ( strcmp( s_ptr, t_ptr ) == 0 )	
			{
				return( fld );
			}
		}
		
	}

	/*----------------------------------------------------------*/
	/* Field name not recognized */
	return( -1 );
}
