%{

#include "y.tab.h"

#undef input
#undef unput

char _curline[1024];
char _unput[1024];
int _curcol;
int _curunp = 0;
int indent = 0;
int _ign_ = 0;
extern int nlflag;
extern char *srcfile;

static g_input() {
	if (_curunp > 0) {
		if (_unput[--_curunp] == '\n')
			yylineno++;
		return _unput[_curunp];
	}
	while (_curline[_curcol] == '\0') {
		if (fgets(_curline, sizeof _curline, yyin) == (char *) 0)
			return 0;
		_curcol = 0;
	}
	if (_curline[_curcol] == '\n')
		yylineno++;
	return _curline[_curcol++];
}
		
input() {
	int ch;

	ch = g_input();
	if (!_ign_ && nlflag) {
		if (ch == ' ')
			indent++;
		else if (ch == '\t')
			do {
				indent++;
			} while (indent % 8 != 0);
	}
	return ch;
}

unput(c) {
	if (_curunp == 0 && _curcol > 0 && _curline[_curcol - 1] == c)
		_curcol--;
	else if (_curunp == sizeof _unput) {
		yyerror("internal error: pushback overflow, char %o (octal)", c);
		exit(1);
	}
	else
		_unput[_curunp++] = c;
	if (c == '\n') {
		yylineno--;
		nlflag = 0;
	}
}

extern char *scanon();
extern char *fldsyn();
extern char *recname();

#include <dbtypes.h>

%}

%%

define { return DEFINE; }
like { return LIKE; }
numeric { return NUMERIC; }
string { return STRING; }
float { return FLOAT; }
amount { return AMOUNT; }
date { return kDATE; }
time { return TIME; }
get { return GET; }
put { return PUT; }
foreach { return FOREACH; }
of { return OF; }
where { return WHERE; }
by { return BY; }
and { return AND; }
between { return BETWEEN; }
not { return kNOT; }
select { return SELECT; }
key { return KEY; }
sort { return SORT; }
messages { return MESSAGES; }
interrupt { return INTERRUPT; }
on { return ON; }
off { return OFF; }
">=" { return GE; }
"<=" { return LE; }
"!=" { return NE; }
"^=" { return NE; }
"->" { return PTR; }
\&?[A-Za-z_][A-Za-z0-9_]* {
	int cnt;
	char *p;

	strcpy(yylval.str, yytext);
	for (cnt = numrecs(); cnt > 0; cnt--) {
		if ((p = recname(cnt)) == (char *) 0)
			continue;
		if (strcmp(p, yytext) == 0) {
			yylval.rec = cnt;
			return tRECORD;
		}
	}
	for (cnt = numflds(); cnt > 0; cnt--) {
		if ((p = fldsyn(cnt)) == (char *) 0)
			continue;
		if (strcmp(p, yytext) == 0)
			return tFIELD;
	}
	return tCONST;
}
-?[0-9]+ {
	yylval.num = atoi(yytext);
	return tNUM;
}
\"([^\\n]*\\\")*[^"\n"]*\" {
	strcpy(yylval.str, yytext);
	return tCONST;
}
[ \t\n]+ ;
. return *yytext;

%%

#include <varargs.h>

char *scanon(buf)
register char *buf; {
	static char cbuf[1024];
	register short bufc;
	char ibuf;

	ibuf = *buf;
	bufc = 0;
	for (buf++; *buf != '\0'; buf++) {
		if (*buf == '\\')
			cbuf[bufc++] = *++buf;
		else if (*buf == ibuf)
			break;
		else
			cbuf[bufc++] = *buf;
	}
	cbuf[bufc] = '\0';
	if (*buf == ibuf && *++buf != '\0')
		yyerror("internal error (canon trailing text \"%s\")", buf);
	return cbuf;
}

yyerror(va_alist)
va_dcl {
	va_list args;
	char *format;
	short uc;

	va_start(args);
	format = va_arg(args, char *);
	fprintf(stderr, "\n\"%s\", line %d: ", srcfile, yylineno);
	vfprintf(stderr, format, args);
	va_end(args);
	fprintf(stderr, "\n> ");
	if (_curunp == 0) {
		short col;

		fprintf(stderr, "%s>-", _curline);
		for (uc = 0, col = 2; uc < _curcol - 1; uc++) {
			if (_curline[uc] == '\t') {
				do {
					putc('-', stderr);
				} while (++col % 8 != 0);
			}
			else {
				putc('-', stderr);
				col++;
			}
		}
		fprintf(stderr, "^\n");
	}
 	else {
		for (uc = _curunp; uc > 0; uc--)
			putc(_unput[uc - 1], stderr);
		fprintf(stderr, "\n>-^\n");
	}
}
