%token FOREACH OF WHERE BY AND BETWEEN kNOT DEFINE LIKE STRING AMOUNT kDATE
%token TIME NUMERIC FLOAT GET PUT SORT MESSAGES INTERRUPT OFF ON KEY SELECT
%token GE LE NE PTR
%token tRECORD tFIELD tCONST tNUM

%union {
	char str[256];
	int fld;
	int rec;
	int opcode;
	struct {
		int nfld;
		int *spec;
	} sort;
	int flag;
	int num;
}

%type <fld> field of
%type <rec> tRECORD
%type <str> tCONST tFIELD type varlist
%type <sort> sortspec
%type <opcode> op
%type <flag> by not switch where key
%type <num> tNUM selection

%{

#include <unisel.h>
#include <fdesc.h>
#include <dbtypes.h>

int crec, jrec, jfld;
long seqn = 0L, xseq = 0L;
int didumsg = 0, didusdcl = 0, didssdcl = 0;

extern char *malloc();
extern char *realloc();
extern char *recname();
extern char *fldsyn();

#define SEL_REL		8
#define SEL_VALUE	4
#define SEL_KEY		2
#define SEL_SORT	1

%}

%%

command		: FOREACH selection '{'
			{
				if ($2 & SEL_KEY) {
					yyerror("`foreach ... key' makes no sense");
					YYERROR;
				}
				switch ($2) {
				case 0:
					putsel("for (__i__er_ = seqacc(%d, 1); __i__er_ == 0; __i__er_ = seqacc(%d, 2)) {", crec, crec);
					break;
				case SEL_VALUE:
				case SEL_REL|SEL_VALUE:
					putsel("\n\1for ((__i__er_ != 0? __i__er_: (__i__er_ = frstsel(__f_%d))); __i__er_ > 0; __i__er_ = nextsel(__f_%d)) {", seqn, seqn);
					break;
				case SEL_REL:
					if (jfld < 0) {
						yyerror("cannot use `foreach' on join to parent");
						YYERROR;
					}
					putsel("\n\1for (__i__er_ = nextrec(%d, %d); __i__er_ == 0; __i__er_ = nextrec(%d, %d)) {", reckey(jrec), jfld, reckey(jrec), jfld);
					break;
				case SEL_REL|SEL_SORT:
				case SEL_REL|SEL_VALUE|SEL_SORT:
				case SEL_VALUE|SEL_SORT:
				case SEL_SORT:
					putsel("\n\1for (__i__er_ = sfrstrec(%d, %d); __i__er_ == 0; __i__er_ = snextrec(%d, %d)) {", reckey(jrec), jfld, reckey(jrec), jfld);
					break;
				}
				YYACCEPT;
			}
		| DEFINE varlist type ';'
			{
				char vbuf[1024];

				sprintf(vbuf, $3, $2);
				putsel("%s;", vbuf);
				YYACCEPT;
			}
		| GET tCONST '=' field ';'
			{
				FLDESC fd;
				char *cp;

				if ($2[0] == '"') {
					yyerror("syntax error");
					YYERROR;
				}
				fldesc($4, &fd);
				if (fd.f_typ != STRNG && fd.f_typ != COMB && $2[0] != '&')
					cp = "&";
				else
					cp = "";
				putsel("gfield(%d, %s%s)", $4, cp, $2);
				if (fd.f_typ == STRNG)
					putsel(", %s[%d] = '\\0'", $2, fd.f_len);
				putsel(";");
				YYACCEPT;
			}
		| PUT field '=' tCONST ';'
			{
				FLDESC fd;
				char *cp;

				fldesc($2, &fd);
				if (fd.f_typ != STRNG && fd.f_typ != COMB && $4[0] != '&')
					cp = "&";
				else
					cp = "";
				putsel("if ((__i__er_ = pfield(%d, %s%s)) != 0)\n\1\terror(\"pfield %s\", __i__er_);", $2, cp, $4);
				YYACCEPT;
			}
		| SORT MESSAGES switch ';'
			{
				if (!didumsg)
					puthead("extern int _No_Umsgs;\n");
				didumsg = 1;
				putsel("_No_Umsgs = %d;", !$3);
				YYACCEPT;
			}
		| SELECT select_cmd ';'
			{
				YYACCEPT;
			}
		;

select_cmd	: INTERRUPT switch
			{
				putsel("setintr(%d);", ($2? INTR_ON: INTR_OFF));

			}
		| selection
			{
				if ($1 & SEL_SORT) {
					yyerror("you cannot use a `by' phrase in a `select' statement");
					YYERROR;
				}
				switch ($1) {
				case 0:
					puthead("static long __n_%d;\n", seqn);
					putsel("if ((__n_%d = getnrec(%d)) != 1)\n\1\terror(\"seqacc %s returned not exactly one record\", __n_%d);", seqn, crec, recname(crec), seqn);
					putsel("\n\1seqacc(%d, 1);", crec);
					break;
				case SEL_KEY:
					break;
				case SEL_REL:
					if (jfld < 0)
						break;
					putsel("\n\1if (__n_%d != 1L)\n\1\terror(\"select %s returned not exactly one record\", __n_%d);\n\1", seqn, recname(crec), seqn);
					/*FALLTHROUGH*/
				default:
					putsel("\n\1if ((__i__er_ = frstrec(__f_%d)) != 0)\n\1\terror(\"frstrec %s\", __i__er_);", seqn, recname(crec));
				}
			}
		;

switch		: OFF
			{
				$$ = 0;
			}
		| ON
			{
				$$ = 1;
			}
		;

selection	: tRECORD
			{
				seqn++;
				crec = $1;
			}
		  of where key by
		  	{
				int v;
				char vbuf[256];
				FLDESC fd;

				v = ($3 == 0? 0: SEL_REL)|($4? SEL_VALUE: 0)|($5? SEL_KEY: 0)|($6? SEL_SORT: 0);
				if ($5 && ($3 != 0 || $4 || $6)) {
					yyerror("cannot use `key' with `of' or `where'");
					YYERROR;
				}
				if ($3 < 0 && ($4 || $6)) {
					yyerror("cannot use `where' or `by' on join to parent");
					YYERROR;
				}
				switch (v) {
				case SEL_REL:
					if ($3 < 0)
						putsel("if ((__i__er_ = faccess(%d, %d)) != 0)\n\1\terror(\"faccess %s\", __i__er_);", crec, - $3, recname(crec));
					else {
						puthead("static long __n_%d;\n", seqn);
						putsel("if ((__i__er_ = makeset(%d, %d, 1)) != 0)\n\1\terror(\"makeset(%s, %s)\", __i__er_);", reckey(jrec), $3, fldsyn(reckey(jrec)), fldsyn($3));
						putsel("\n\1setsize(%d, %d, &__n_%d);", reckey(jrec), $3, seqn);
					}
					jfld = $3;
					break;
				case SEL_REL|SEL_SORT:
					if (!didssdcl) {
						didssdcl = 1;
						puthead("static int (*__no_f__[])() = {0, 0, 0, 0};\n");
					}
					putsel("(void) unisort(%d, %d, __s_%d, __no_f__);", jrec, $3, seqn);
					jfld = $3;
					break;
				case 0:
				case SEL_KEY:
					break;
				case SEL_REL|SEL_VALUE:
					fldesc(reckey(jrec), &fd);
					sprintf(vbuf, utype(fd.f_typ, (fd.f_typ == FLT? fd.f_len * 10: fd.f_len)), "__j_%d");
					puthead("static ");
					puthead(vbuf, ++xseq);
					puthead(";\n");
					fldesc($3, &fd);
					putsel("gfield(%d, __j_%d);\n\1entsitm(%d, __j_%d, (char *) 0, %d);\n\1", fd.f_rpfld, xseq, $3, xseq, EQ);
					/*FALLTHROUGH*/
				case SEL_VALUE:
					if (!didusdcl) {
						didusdcl = 1;
						puthead("extern struct uselfil *opensf();\n");
					}
					puthead("static struct uselfil *__f_%d = (struct uselfil *) 0;\nstatic char __t_%d[] = \"/tmp/,ts_XXXXXX\";\nstatic long __n_%d;\n\n", seqn, seqn, seqn);
					putsel("mktemp(__t_%d);\n\1if (__f_%d != (struct uselfil *) 0)\n\1\tclosesf(__f_%d);\n\1", seqn, seqn, seqn);
					putsel("if ((__i__er_ = unisel(__t_%d, %d, &__n_%d)) != 0 && __i__er_ != -1 && __i__er_ != -7)\n\1\terror(\"unisel %s\", __i__er_);\n\1", seqn, crec, seqn, recname(crec));
					putsel("if ((int) (__f_%d = opensf(__t_%d)) == -1)\n\1\terror(\"opensf %s\", -1);\n\1unlink(__t_%d);", seqn, seqn, recname(crec), seqn);
					break;
				case SEL_REL|SEL_VALUE|SEL_SORT:
					fldesc(reckey(jrec), &fd);
					sprintf(vbuf, utype(fd.f_typ, (fd.f_typ == FLT? fd.f_len * 10: fd.f_len)), "__j_%d");
					puthead("static ");
					puthead(vbuf, ++xseq);
					puthead(";\n");
					fldesc($3, &fd);
					putsel("gfield(%d, __j_%d);\n\1entsitm(%d, __j_%d, (char *) 0, %d);\n\1", fd.f_rpfld, xseq, $3, xseq, EQ);
					/*FALLTHROUGH*/
				case SEL_SORT:
				case SEL_VALUE|SEL_SORT:
					if (!didssdcl) {
						didssdcl = 1;
						puthead("static int (*__no_f__[])() = {0, 0, 0, 0};\n");
					}
					putsel("if ((__i__er_ = selsort(%d, __s_%d, __no_f__)) != 0 && __i__er_ != -1)\n\1\terror(\"unisort %s\", __i__er_);", crec, seqn, recname(crec));
					jfld = SS;
					jrec = crec;
					break;
				default:
					yyerror("illegal combination of selection phrases (%d)", v);
					YYERROR;
				}
				$$ = v;
			}
		;

where		: /* none */
			{
				$$ = 0;
			}
		| WHERE selfield
			{
				$$ = 1;
			}
		;

of		: /* none */
			{
				$$ = 0;
			}
		| OF tRECORD
			{
				int cnt;
				FLDESC fd;

				for (cnt = numflds(); cnt > 0; cnt--)
					if (!fldesc(cnt, &fd))
						continue;
					else if (fd.f_rec == crec && fd.f_rprec == $2)
						break;
					else if (fd.f_rec == $2 && fd.f_rprec == crec)
						break;
				if (cnt == 0) {
					yyerror("record type %s does not join to %s", recname($2), recname(crec));
					YYERROR;
				}
				jrec = $2;
				$$ = (fd.f_rec == crec? cnt: -cnt);
			}
		;

key		: /* none */
			{
				$$ = 0;
			}
		| KEY tCONST
			{
				FLDESC fd;
				char *cp;
				int thekey;

				if ((thekey = reckey(crec)) == 0) {
					yyerror("record type %s has no key", recname(crec));
					YYERROR;
				}
				fldesc(thekey, &fd);
				if (fd.f_typ != STRNG && fd.f_typ != COMB && $2[0] != '&')
					cp = "&";
				else
					cp = "";
				putsel("if ((__i__er_ = acckey(%d, %s%s)) != 0)\n\1\terror(\"acckey %s\", __i__er_);", crec, cp, $2, recname(crec));
				$$ = 1;
			}
		;

selfield	: sel
		| selfield AND sel
		;

sel		: field op tCONST
			{
				FLDESC fd;

				fldesc($1, &fd);
				if (fd.f_rec != crec) {
					yyerror("field %s is not in record type %s", fldsyn($1), recname(crec));
					YYERROR;
				}
				putsel("entsitm(%d, %s, (char *) 0, %d);\n\1", $1, $3, $2);
			}
		| field not BETWEEN tCONST AND tCONST
			{
				FLDESC fd;

				fldesc($1, &fd);
				if (fd.f_rec != crec) {
					yyerror("field %s is not in record type %s", fldsyn($1), recname(crec));
					YYERROR;
				}
				putsel("entsitm(%d, %s, %s, %d);\n\1", $1, $4, $6, ($2? NOT: EQ));
			}
		;

not		: /* none */
			{
				$$ = 0;
			}
		| kNOT
			{
				$$ = 1;
			}
		;

by		: /* none */
			{
				$$ = 0;
			}
		| BY
			{
				puthead("static int __s_%d[] = {\n", seqn);
			}
		  sortlist
			{
				puthead("-1};\n");
				$$ = 1;
			}
		;

sortlist	: sort
		| sortlist ',' sort
		;

sort		: sortspec
			{
				int cnt;

				for (cnt = $1.nfld; cnt > 0; cnt--)
					puthead(" %d,", $1.spec[cnt - 1]);
				puthead(" 0,\n");
				free($1.spec);
			}
		;

sortspec	: field
			{
				FLDESC fd;

				fldesc($1, &fd);
				if (fd.f_rec != crec) {
					yyerror("field %s is not in record type %s", fldsyn($1), recname(crec));
					YYERROR;
				}
				$$.nfld = 1;
				if (($$.spec = (int *) malloc(sizeof (int))) == (int *) 0) {
					yyerror("out of memory in firstsort");
					YYERROR;
				}
 				$$.spec[0] = $1;
			}
		| sortspec PTR field
			{
				FLDESC fd, jfd;

				fldesc($3, &fd);
				fldesc($1.spec[$$.nfld - 1], &jfd);
				if (jfd.f_rprec != fd.f_rec) {
					yyerror("no explicit relationship between %s and %s.%s", fldsyn($1), recname(fd.f_rec), fldsyn(reckey(fd.f_rec)));
					YYERROR;
				}
				$$ = $1;
				if (($$.spec = (int *) realloc($$.spec, (unsigned) ++$$.nfld * sizeof (int))) == (int *) 0) {
					yyerror("out of memory in nextsort");
					YYERROR;
				}
				$$.spec[$$.nfld - 1] = $3;
			}
		;

field		: tFIELD
			{
				int cnt;
				char *cp;

				for (cnt = 1; cnt <= numflds(); cnt++) {
					if ((cp = fldsyn(cnt)) == (char *) 0)
						continue;
					if (strcmp(cp, $1) == 0)
						break;
				}
				$$ = cnt;
			}
		| tRECORD '.' tFIELD
			{
				FLDESC fd;
				int cnt;
				char *cp;

				for (cnt = numflds(); cnt > 0; cnt--) {
					if ((cp = fldsyn(cnt)) == (char *) 0)
						continue;
					if (strcmp(cp, $3) != 0)
						continue;
					fldesc(cnt, &fd);
					if (fd.f_rec == $1)
						break;
				}
				if (cnt == 0) {
					yyerror("field %s is not in record type %s", $3, recname($1));
					YYERROR;
				}
				$$ = cnt;
			}
		;

op		: '>'
			{
				$$ = GT;
			}
		| '='
			{
				$$ = EQ;
			}
		| '<'
			{
				$$ = LT;
			}
		| LE
			{
				$$ = LTE;
			}
		| GE
			{
				$$ = GTE;
			}
		| NE
			{
				$$ = NOT;
			}
		;

type		: LIKE field
			{
				FLDESC fd;

				fldesc($2, &fd);
				strcpy($$, utype(fd.f_typ, (fd.f_typ == FLT? fd.f_len * 10: fd.f_len)));
			}
		| STRING tNUM
			{
				strcpy($$, utype(STRNG, $2));
			}
		| NUMERIC tNUM
			{
				strcpy($$, utype(($2 > 4? LONG: INT), $2));
			}
		| AMOUNT tNUM
			{
				strcpy($$, utype(($2 > 7? HAMT: AMT), $2));
			}
		| FLOAT tNUM
			{
				strcpy($$, utype(FLT, $2));
			}
		| kDATE
			{
				strcpy($$, utype(DATE, 0));
			}
		| TIME
			{
				strcpy($$, utype(HR, 0));
			}
		;

varlist		: tCONST
			{
				if ($1[0] == '"' || $1[0] == '&') {
					yyerror("syntax error");
					YYERROR;
				}
				strcpy($$, $1);
			}
		| varlist ',' tCONST
			{
				if ($3[0] == '"' || $3[0] == '&') {
					yyerror("syntax error");
					YYERROR;
				}
				strcpy($$, $1);
				strcat($$, ", ");
				strcat($$, $3);
			}
		;

%%
