'''
''' USP (UNIFY(r) Selection Preprocessor)
'''
.TH USP 1L
.SH NAME
usp \- unify(R) selection preprocessor
.SH SYNOPSIS
.B usp <
.I file.c
.B >
.I outfile.c
.SH DESCRIPTION
.I Usp
is a preprocessor for C programs which use the Unify\*R C HLI.  It obviates
the need for the Unify preprocessor,
.BR upp ,
and the include file
.IR file.h ,
while providing more features including automatic date translation and a
simple selection language.
.SH USAGE
.SS Invocation
At present, the
.B usp
command reads a C program from standard input and writes a modified copy of
the program to standard output.  The modifications are triggered by a dollar
sign character
.BR ($) .
The output file is preceded by definitions used by the succeeding code.
.SS Syntax
.BR Usp 's
translation capabilities are triggered by a dollar sign character.  If the
character appears in column 1 of a line, it triggers a command translation.
If the character is in any other column, it triggers a record, field or date
translation.
.SS Command syntax
The 
.B usp
command processor recognizes a limited subset of commands associated with
data selection and retrieval.  The command syntax is described by the
following BNF syntax:
.de Bs
.in +15
.ll -5
.sp 2
.ns
..
.de Bn
.ti -10
.sp
\\$1 ::= \\$2
.if \w\\$3 | \\$3
.if \w\\$4 | \\$4
.if \w\\$5 | \\$5
.if \w\\$6 | \\$6
.if \w\\$7 | \\$7
.if \w\\$8 | \\$8
.if \w\\$9 | \\$9
..
.de Be
.in -15
.ll +5
.sp 2
.ns
..
.Bs
.Bn <command> <define> <get> <put> <foreach> <select> <sort>
.Bn <define> "define <variable> { like <field> | <type> } ;"
.Bn <get> "get <variable> = <field> ;"
.Bn <put> "put <field> = <variable> ;"
.Bn <foreach> "foreach <selection> {"
.Bn <select> "select { <selection> | interrupt <switch> }"
.Bn <sort> "sort messages <switch>"
.Bn <selection> "<record> [[of <record>] [where <condition>] [by <keys>] | key <const>]"
.Bn <switch> on off
.Bn <condition> <basic> "<condition> and <basic>"
.Bn <basic> "<field> <op> <variable>"
.Bn <op> = ^= > >= < <=
.Bn <type> "numeric <integer>" "amount <integer>" "float <integer>" "string <integer>" date time
.Bn <field> "[<record>.]<fsyn>"
.Bn <variable> "[&]<identifier>" <string>
.Bn <keys> <key> "<keys> , <key>"
.Bn <key> <field> "<key> -> <field>"
.Be
Note that
.BR <integer> , " <string>" ", and " <identifier>
are standard C constructs; refer to a C programming manual for more information.
.SS Commands
The following commands are accepted by 
.BR usp :
.RS 5
.IP "define <variable>" 5
Define a variable, either "like" a database field or as a Unify\*R type.  This
is basically a convenience.
.IP "get <variable> = <field>" 5
Assign the contents of a database field to a variable.  This is essentially a
.IR gfield ,
with the exception that a string field will automatically be null-terminated
at the end of its defined length.  This requires that a string variable be
defined one character longer than the corresponding Unify\*R field; the
.B define
command already does this.
.IP "put <field> = <variable>" 5
The inverse of
.BR get ;
it does a
.I pfield
operation.  It will call
.I error
if the operation fails.
.IP "foreach <selection>" 5
The first of the selection commands; it is capable of dealing with multiple
returned records.  It begins a loop which, in the generated program, is a
.I for
loop.  See
.I Selections
for more information.
.IP "select <selection>" 5
The other selection command; it returns exactly one record.
.IP "select interrupt <switch>" 5
controls whether queries may be interrupted; if a 
.B foreach
query is interupted, the enclosed loop is not executed.
.IP "sort messages <switch>" 5
The
.B sort messages
command controls whether the sorting versions of the
.B foreach
command will display the messages
.IR Selecting , " Sorting" ", and " Formatting" .
.RE
.SS Selections
A
.B selection
is a specification of which rows of which table will be returned by a query.
It is not as complex as is possible with
.BR SQL ,
but is complex enough to simplify many programming projects.
.P
The basic form of a selection is shown by the BNF syntax above.  The only
semantic conditions are as follows:
.RS 5
.IP -
The syntax
.B foreach ... key
is illegal;
.IP -
The syntax
.B select ... by
is illegal; and
.IP -
The `&' character is required on non-string variables.
.RE
.P
The `of' keyword exploits explicit relationships.  It also determines
automatically whether the relationship is being followed in a one-to-many or a
many-to-one direction.
.P
Sorting is always in ascending order; the "->" syntax is used to follow
explicit relationship chains.  See the descrition of the
.I unisort
function in the Unify\*R Programmer's manual, but note that the "->" chain is
reversed in order from the sort array.
.SS Non-command syntax
The 
.B usp
processor also translates bjects when it sees a `$' character in the middle of
a line.  In this case, the character following the $ is inspected.  If it is a
left parenthesis `(', then the object is a date.  Dates have the following syntax:
.RS 20
.sp
$(mm/dd/yy)
.br
$(**/**/**)
.br
$(today)
.sp
.RE
The `$(today)' syntax expands to a static function call.
.P
If the character following the `$' is not a left parenthesis, then the following
identifier is interpreted as a record or short field name.  If it cannot be
translated as either, an error occurs.
.SH "SEE ALSO"
The Unify\*R Programmer's Manual
.SH ACKNOWLEDGEMENTS
Unify is a registered trademark of Unify Corporation.
.SH BUGS
It is likely that hand-coding selections would produce more optimal code,
although 
.B usp
tries valiantly and recognizes at least twelve kinds of queries.
.P
The 
.B $field
construct should allow
.I field.record
syntax.  This, alas, would require a much more complex parser.
.P
All programs have a two-line definition prepended to them, whether the
definition is used or not.
.P
If two separate source files for a program use the `$(today)' structure, each
file will have a static function prepended to it.  This is somewhat wasteful
but avoids having to link a special library into the program.
