#include <stdio.h>
#include <varargs.h>
#include <dbtypes.h>

extern FILE *yyin, *yyout;
extern FILE *tmpfile();
extern char *recname();
extern char *fldsyn();
extern char *fldname();
extern char *strchr();

static FILE *htf = (FILE *) 0;
static FILE *stf = (FILE *) 0;
static char vname[] = "_ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
int nlflag = 1;
static int diddate, dosync;
char *srcfile = "-";
extern int indent, _ign_, yylineno;
static int *typetab = (int *) 0;

/*VARARGS PRINTFLIKE1*/
puthead(va_alist)
va_dcl {
	char *fmt;
	va_list args;

	va_start(args);
	fmt = va_arg(args, char *);
	vfprintf(htf, fmt, args);
	va_end(args);
	if (fmt[strlen(fmt) - 1] == '\n')
		syncf(htf);
}

/*VARARGS PRINTFLIKE1*/
putsel(va_alist)
va_dcl {
	char *fmt;
	va_list args;
	static char buf[5120];

	va_start(args);
	fmt = va_arg(args, char *);
	vsprintf(buf, fmt, args);
	va_end(args);
	__emit(buf);
}

static __emit(buf)
char *buf; {
	for (; *buf != '\0'; buf++) {
		if (*buf == '\1') {
			syncf(stf);
			lead(indent);
			continue;
		}
		putc(*buf, stf);
	}
}

syncf(fp)
FILE *fp; {
	fprintf(fp, "#line %d", yylineno);
	if (yyin != stdin)
		fprintf(fp, " \"%s\"", srcfile);
	putc('\n', fp);
}

static lead(cnt) {
	while (cnt > 8) {
		putc('\t', stf);
		cnt -= 8;
	}
	while (cnt-- > 0)
		putc(' ', stf);
}

dumpf(fp, dest)
FILE *fp, *dest; {
	int ch;

	yyin = fp;
	nlflag = 1;
	diddate = 0;
	dosync = 1;
	if (typetab != (int *) 0) {
		free((char *) typetab);
		typetab = 0;
	}
	if (htf == (FILE *) 0 && (htf = tmpfile()) == (FILE *) 0) {
		yyerror("can't open temp file for header");
		exit(2);
	}
	fprintf(htf, "static int __i__er_ = 0;\n");
	if (stf == (FILE *) 0 && (stf = tmpfile()) == (FILE *) 0) {
		yyerror("can't open temp file for code");
		exit(2);
	}
	while ((ch = input()) != 0) {
		if (ch == '$') {
 			if (nlflag && indent == 0) {
				indent = 1;	/* '$' == space for output */
				if ((ch = input()) != '\t')
					putc(' ', stf);
				while (ch == ' ' || ch == '\t') {
					putc(ch, stf);
					ch = input();
				}
				unput(ch);
				_ign_ = 1;
				yyparse();
				_ign_ = 0;
				nlflag = 0;
				dosync = 1;
			}
			else {	/* embedded record/field ref */
				char vbuf[256];
				int cnt;
				char *cp;

				cnt = 0;
				nlflag = 0;
				while ((ch = input()) != 0 && strchr(vname, ch) != (char *) 0)
					vbuf[cnt++] = ch;
				if (cnt == 0 && ch == '(') {
					parsedate();
					continue;
				}
				unput(ch);
				if (cnt == 0) {
					putc('$', stf);
					continue;
				}
				vbuf[cnt] = '\0';
				for (cnt = numrecs(); cnt > 0; cnt--) {
					if ((cp = recname(cnt)) == (char *) 0)
						continue;
					else if (strcmp(cp, vbuf) == 0)
						break;
				}
				if (cnt != 0) {
					fprintf(stf, "%d", cnt);
					continue;
				}
				for (cnt = numflds(); cnt > 0; cnt--) {
					if ((cp = fldname(cnt)) == (char *) 0)
						continue;
					else if (strcmp(cp, vbuf) == 0)
						break;
				}
				if (cnt != 0)
					fprintf(stf, "%d", cnt);
				else {
					yyerror("unrecognized record/field name `%s'", vbuf);
					fputs(vbuf, stf);
				}
			}
		}
		else {
			if (ch != '\n' && ch != ' ' && ch != '\t')
				nlflag = 0;
			else if (ch == '\n') {
				indent = 0;
				nlflag = 1;
			}
			putc(ch, stf);
			if (dosync && ch == '\n') {
				syncf(stf);
				dosync = 0;
			}
		}
	}
	rewind(htf);
	rewind(stf);
	while ((ch = getc(htf)) != EOF)
		putc(ch, dest);
	putc('\n', dest);
	while ((ch = getc(stf)) != EOF)
		putc(ch, dest);
	fclose(htf);
	fclose(stf);
	htf = (FILE *) 0;
	stf = (FILE *) 0;
}

main(argc, argv)
char **argv; {
	char fname[1024];
	FILE *inf, *outf;
	int arg, len;

	srcfile = "-";
	if (argc < 2)
		dumpf(stdin, stdout);
	else
		for (arg = 1; argv[arg] != (char *) 0; arg++) {
			strcpy(fname, argv[arg]);
			len = strlen(fname);
			if (fname[len - 2] == '.' && fname[len - 1] == 'c')
				strcpy(fname + len - 1, "usp.c");
			else
				strcat(fname, ".c");
			if ((inf = fopen(argv[arg], "r")) == (FILE *) 0) {
				perror(argv[arg]);
				continue;
			}
			if ((outf = fopen(fname, "w")) == (FILE *) 0) {
				perror(fname);
				fclose(inf);
				continue;
			}
			srcfile = argv[arg];
			dumpf(inf, outf);
			fclose(inf);
			fclose(outf);
		}
	exit(0);
}

char *utype(type, len) {
	static char buf[256];

	switch (type) {
	case INT:
	case DATE:
	case HR:
		strcpy(buf, "short %s");
		break;
	case LONG:
	case AMT:
		strcpy(buf, "long %s");
		break;
	case HAMT:
	case FLT:
		strcpy(buf, "double %s");
		break;
	case STRNG:
		len++;
	case COMB:
		typeset(len);
		sprintf(buf, "_str_%d %%s", len);
		break;
	}
	return buf;
}

/*
 * Make an entry in the typeset table.  Do nothing if it's in there already.
 */

typeset(len) {
	int cnt;

	for (cnt = 0; typetab != (int *) 0 && typetab[cnt] != 0; cnt++)
		if (typetab[cnt] == len)
			return;
	cnt += 2;
	if ((typetab = (int *) (typetab == (int *) 0? malloc(cnt * sizeof (int)): realloc(typetab, cnt * sizeof (int)))) == (int *) 0) {
		yyerror("out of memory for defined type table");
		exit(1);
	}
	typetab[cnt - 2] = len;
	typetab[cnt - 1] = 0;
	puthead("typedef char _str_%d[%d];\n", len, len);
}

/*
 * input() next call will start a date, to a ')'.  Parse the date, eat the
 * ')', and output the internal (short) value of the date.  `/' only.
 * Actually, times are handled as well; the deciding factor is whether
 * a '/' or a ':' is used.
 *
 * Three special cases: (nulldate), "hour", and "today".  (I can't specify
 * nulldate's form in a comment for obvious reasons; the string is the standard
 * UNIFY one.)
 */

parsedate() {
	char dbuf[256], term[2];
	int ch, cnt;
	int date[3], ck[3];
	short d;

	for (cnt = 0; (ch = input()) != 0 && ch != '\n' && ch != ')'; cnt++)
		dbuf[cnt] = ch;
	dbuf[cnt] = '\0';
	if (ch != ')' || cnt == 0) {
		yyerror("unterminated or empty date/time constant");
		fprintf(stf, "$(%s", dbuf);
		return;
	}
	if (strcmp(dbuf, "**/**/**") == 0) {
		fprintf(stf, "%d", NULLDATE);
		return;
	}
	if (strcmp(dbuf, "today") == 0) {
		fprintf(stf, "(_u__now = time((long *) 0), _u__date = localtime(&_u__now), _u__today[0] = _u__date->tm_mon + 1, _u__today[1] = _u__date->tm_mday, _u__today[2] = _u__date->tm_year, kday(_u__today))");
		if (!diddate)
			puthead("#include <time.h>\nstatic int _u__today[3];\nstatic long _u__now;\nstatic struct tm *_u__date;\n");
		diddate = 1;
		return;
	}
	if (strcmp(dbuf, "hour") == 0) {
		fprintf(stf, "(_u__now = time((long *) 0), _u__date = localtime(&_u__now), _u__date->tm_hour * 100 + _u__date->tm_min)");
		if (!diddate)
			puthead("#include <time.h>\nstatic int _u__today[3];\nstatic long _u__now;\nstatic struct tm *_u__date;\n");
		diddate = 1;
		return;
	}
	dbuf[cnt++] = ')';	/* hack for sscanf checking */
	dbuf[cnt] = '\0';
	if ((cnt = sscanf(dbuf, "%d:%d%[)]", &date[0], &date[1], term)) == 3) {
		if (date[0] < 0 || date[0] > 23) {
			yyerror("syntax error in time/hour");
			fprintf(stf, "$(%s", dbuf);
			return;
		}
		if (date[1] < 0 || date[1] > 59) {
			yyerror("syntax error in time/minute");
			fprintf(stf, "$(%s", dbuf);
			return;
		}
		fprintf(stf, "%d", date[0] * 100 + date[1]);
		return;
	}
	if ((cnt = sscanf(dbuf, "%d/%d/%d%[)]", &date[0], &date[1], &date[2], term)) != 4) {
		yyerror("syntax error in date (section %d)", cnt);
		fprintf(stf, "$(%s", dbuf);
		return;
	}
	d = kday(date);
	kdate(d, ck);
	if (!ivcmp(ck, date, sizeof date)) {
		yyerror("invalid date spec");
		d = NULLDATE;
	}
	fprintf(stf, "%d", d);
}
