.\ "@(#)cardfile.man	3.1 Delta Date 8/3/90  ExtrDate 10/6/90 ";
.if t .po 1i
.TH CARDFILE 1 djl
.SH NAME
cardfile \- simple index card database
.SH SYNOPSIS
\fBcardfile [-r] file\fP
.SH DESCRIPTION
.I Cardfile
is a simple screen oriented index card database program.
If
.I file
does not exist,
.I cardfile
will prompt for a definition of the fields to appear in each record.
Each field has:
.IP \(bu
a name
.IP \(bu
the maximum length of the field
.IP \(bu
a flag to determine if it is required or not
.IP \(bu
a flag to determine if the field is indexed
(whether or not it can be searched for)
.IP \(bu
if multiple values may appear in the field,
what character will separate the values,
for example a book may have multiple authors separated by semicolons
.IP \(bu
what screen page this field will appear on
.IP \(bu
what position on the screen (line and column) the field title will appear in
.IP \(bu
what position the field data will start in
#ifndef NO_RE
.IP \(bu
a regular expression defining the
required format of the data in the field.
#endif
.PP
The position fields are not required and \fIcardfile\fP does
not check for overlap.
When all fields have been defined,
return a blank screen and
.I cardfile
will create all necessary files and exit.
Reenter
.I cardfile
with the same filename and you will be able to start adding the data.
.P
The \fB-r\fP flag tells \fIcardfile\fP to open the database readonly.
You must use this flag to retrieve data from a database on which
you do not have write permission.
When \fIcardfile\fP starts, the main menu is the first screen presented.
You may use the cursor keys or the tab keys to move.
When the cursor is next to the option desired the return key
will select it.
The options on the main menu are:
.SS Find
The \fIFIND\fP option is used to retrieve data from the file.
You will be presented with a screen containing all the fields flagged
as index fields.
Enter the value for which you wish to search.
#ifdef NO_RE
If the value is enclosed in quotes (\fB"\fP) it must match exactly.
Otherwise, case is ignored and asterisk (\fB*\fP) can be used at the
end of a string to match anything,
i.e. \fIFarmer*\fP will match "Farmer,P.J." or "farmer,philip",
or "FARMER9999".
#else
If the value is enclosed in quotes, case is significant,
otherwise it is ignored.
It is a real regular expression match, \fIlog\fP will match
"Archaeology", "Logistics" and "analog circuits" for example.
The full regular expression syntax of ed is supported.
#endif
Search values within a field may be connected by "\fB&\fP" for
\fBand\fP or "\fB|\fP" for \fBor\fP,
i.e. if you enter "1986|1987" any record with a value of 1986
or 1987 will be selected
("and" only makes sense if multiple values are allowed in the field).
If values are entered in multiple fields, a record must satisfy
both criteria to be selected.
.P
When all values have been input,
hit return and the database will be searched.
The selected records will be displayed on the screen one at a time.
Return will display the next record,
Ctrl-B will move backwards through the list,
and Esc will abort the display.
.if t .bp
.SS Add
The \fIADD\fP option is used to add a new record to the database.
You will be presented with a screen with all the fields defined
on the record.
The maximum size of each field will appear after the field name.
When all the data has been entered for a record,
return will save the data and blank the fields.
The data is not actually written to the file until
you leave the \fIadd\fP screen.
To leave the \fIADD\fP screen simply return a blank screen.
.SS Change
The \fICHANGE\fP option starts out like \fIFIND\fP but
when the selected records are displayed,
Ctrl-C will display an \fIADD\fP screen with the data from
the selected record as the initial value of each field.
Change the data as desired and then hit return to write the data
and display the next selected record.
.SS Delete
The \fIDELETE\fP option starts out like \fIFIND\fP but
when the selected records are displayed,
Ctrl-D will delete the record from the database.
The record is not physically deleted from the file until
\fICOMPRESS\fP is run, the record is only marked and ignored.
.SS Print
The \fIPRINT\fP option is used to format and print the database
or a subset of the database.
The first screen asks for the output format, the extracted file
if any (see \fIExtract\fP on the \fIMaintenance\fP menu),
the output file, and the output width.
.if n .P
Any character in the output format will be printed as entered
except for \fB%\fP sequences.
The recognized sequences are:
.nf
.ta 0.5i,1.5i
	%N	The contents of field N
	%N(form)	The contents of field N in \fIprintf\fP(3) 
		"%form" format, i.e. "%1(%-20s)" will print
		field 1 left justified in a 20 character field.
	%n	Print a new-line.
	%t	Output a tab character.
	%f	Output a form feed.
	%t(NN)	Advance to column NN.
	%%	Print a %.
.fi
If the extract name field is left blank, the entire database will be dumped.
The output file may be an ordinary file,
or it may be specified as "| \fIcommand\fP" in which case
\fIcommand\fP will be started and the print piped to it.
If the output width is missing, it defaults to 80.
.SS Exit
The \fIEXIT\fP option will return to UNIX.
.SS Maintenance
The \fIMAINTENANCE\fP option will generate a submenu of infrequently used actions.
The actions available from the maintenance menu are:
.br
.RS 0.25i
.B Dump
.br
.RS 0.25i
The \fIDUMP\fP option of the maintenance menu
is used to dump all records in the database and in the index files
to the printer.
The records are not formated, they are printed exactly as in the database.
.RE
.B Compress
.br
.RS 0.25i
The \fICOMPRESS\fP option of the maintenance menu
will reclaim the space taken by records marked as deleted
and then will rebuild the index files.
After \fICOMPRESS\fP has been run a record can no longer be recovered.
.RE
.B "Rebuild AK's"
.br
.RS 0.25i
The \fIREBUILD AK's\fP option of the maintenance menu
will recreate the index files from the main database file.
This is necessary if the main database has been changed by any means
other than this program.
.RE
.B Extract
.br
.RS 0.25i
The \fIEXTRACT\fP option of the maintenance menu
is used to write selected records from the
database to another file.
You are first asked for the name of the output file and then
presented with a screen like \fIFIND\fP to select the records to
be extracted.
.RE
.B Exit
.br
.RS 0.25i
The \fIEXIT\fP option of the maintenance menu will return to the main menu.
.RE
.br
.SH "CONTROL KEYS"
The keys used to control the screens are defined in \fItermcap\fP(4).
.sp
.nf
.ta 0.5i,1.5i,3i
	TERMCAP	UNIX-PC	ACTION
	CAP-NAME	KEY
.sp
	kcuf1	\(->	move right or to next field if at
			end of field
.if t .sp 0.5
	kcub1	\(<-	move left or to previous field if
			at start of field
.if t .sp 0.5
	kbs	Back	same as kcub1
		Space
.if t .sp 0.5
	ht	Tab	move to start of next field
.if t .sp 0.5
	kcud1	Down	same as ht
		Arrow
.if t .sp 0.5
	kcbt	shift-	move to start of this field or previous
		Tab	field if at start
.if t .sp 0.5
	kcuu1	Up	same as kcbt
		Arrow
.if t .sp 0.5
	kel	Clear	clear to end of field
		Line
.if t .sp 0.5
	kf4	Funct	same as kel
		Key 4
.if t .sp 0.5
	kdch1	Dlete	delete character under cursor
		Char
.if t .sp 0.5
	kf3	Funct	same as kdch1
		Key 3
.if t .sp 0.5
	kich1	Input	insert a blank under the cursor
		Mode
.if t .sp 0.5
	kf2	Funct	same as kich1
		Key 2
.if t .sp 0.5
	kf5	Funct	go to the next page of a multi-page form
		Key 5
.if t .sp 0.5
	kf6	Funct	go to the previous page of a multi-page form
		Key 6
.fi
.SH FILES
.ta 1.5i
\fIfile\fP.def	The file of field and file definitions
.br
\fIfile\fP.db	The database records
.br
\fIfile\fP.ak\fBN\fP	The index files for searches
.SH NOTE
No field may contain a colon "\fB:\fP" as it is used as a field
separator in the database.
.if t .sp 0.5v
.if n .br
The maximum size of a field is 255 characters
and of the total record is 1024 characters.
The maximum number of fields in a record is 15.
These are arbitrary numbers and are easy to change at compile time.
.if t .sp 0.5v
.if n .br
At least one field must be defined as an index field.
.if t .sp 0.5v
.if n .br
The regular expressions used as formats and search fields are those supported
by the library functions.
Remember that if a field is supposed to be numeric,
\&'[0-9]*' will not work, '^[0-9]*$' is necessary.
.if t .sp 0.5v
.if n .br
The termcap name
.I kcbt
may not be defined in some versions of UNIX.
Just use the up arrow instead.
.if t .sp 0.5v
.if n .br
There is no concurrency control in \fIcardfile\fP.
