#ifndef lint
static char Sccsid[] = "@(#)fmt_chk.c	3.1    DeltaDate 8/3/90    ExtrDate 10/6/90";
#endif

/*
**	FMT_CHK.C
**
** Return 0 if field matches fmt, 1 otherwise
**
**/

#include	<stdio.h>
#include	"cardfile.h"
#ifdef BSD_RE
extern	char	*re_comp();
extern	int	re_exec();
#endif
#ifdef SYSV_RE
extern	char	*regcmp();
extern	char	*regex();
#endif
#ifdef PD_RE
#include	<regexp.h>
extern	regexp	*regcomp();
extern	int	regexec();
#endif


int
fmt_chk(field, fmt)
char	*field, *fmt;
{
    static char	lastval[MAXFMT];
#ifdef BSD_RE
    int		rc;
#endif
#ifdef SYSV_RE
    char	*rc;
    static char	*cval;
#endif
#ifdef PD_RE
    int		rc;
    static regexp *cval;
#endif
#ifdef NO_RE
    return(0);
#endif

    if (fmt == NULL || *fmt == '\0')
	return(0);
    
    if (strcmp(fmt, lastval) != 0) {
	strcpy(lastval, fmt);
#ifdef BSD_RE
	if (re_comp(fmt) != 0) {
#else
	if (cval)
	    free(cval);
# ifdef SYSV_RE
	if ((cval = regcmp(fmt, 0)) == 0) {
# else	/* PD_RE */
	if ((cval = regcomp(fmt, 0)) == 0) {
# endif
#endif	/* BSD_RE */
	    msg("Invalid format specification");
	    return(-1);
	}
    }

#ifdef BSD_RE
    if ((rc = re_exec(field)) != 1) {
	return(1);
    }
#endif
#ifdef SYSV_RE
    if ((rc = regex(cval, field)) == NULL) {
	return(1);
    }
#endif
#ifdef PD_RE
    if ((rc = regexec(cval, field)) == NULL) {
	return(1);
    }
#endif
    return(0);
}

#ifdef PD_RE
/* Let cardfile handle errors */
void
regerror(msg)
char	*msg;
{
    return;
}
#endif
