
/*
 * @(#)asm.h	1.3 
 * Header.
 *
 * General assembler header. With this structure you
 * can define the majority of the simple assembler 
 * dependent variables.
 *
 * David A Klotzbach
 *
 * Sizes of tables.
 */

#define NCPS	16		/* Characters per symbol */
#define CLMAX	256		/* Code bytes, line */
#define CBMAX	16		/* Code bytes, object */
#define USERMAX	2		/* User names */
#define SRCMAX	128		/* Source line length */
#define ERRMAX	5		/* Maximum errors per line +1 */
#define FALSE	0		/* not true			*/
#define TRUE	1		/* You should be able to guess	*/
#define mxline	55		/* maximum lines per page*/

#define dot	(&ust[0])	/* Location counter */
#define CDOT	'$'		/* Character that means current PC */
#define BSWAP   0		/* 1 = High first; 0 = Low first   */
#define MICRO	"8080"
#define TASK	"ASM80"		/* The task that is to be run */
#define HASH	28

/*
 * Listing control modes.
 * Go in `listmode'.
 */
#define NLIST	0		/* No list */
#define SLIST	1		/* Source only list */
#define ALIST	2		/* Just address */
#define CLIST	3		/* Address and code */

/*
 * Symbol table structure.
 * Used in both the user symbol table and
 * the opcode table.
 */
struct hu{
	struct hu *next;	/* Next usage	*/
	int	line;		/* Line used	*/
	char	how;		/* How it was used */
	};

#define	U_DEFINE	'd'	/* Defined	*/
#define U_EXPR		'e'	/* used in expres */
#define U_EQU		'='	/* EQU or SET	*/
		
struct sym {
	char s_name[NCPS];	/* Name */
	struct sym *left;	/* left member	*/
	struct sym *right;	/* right member */
	char s_type;		/* Type */
	char s_flag;		/* Some flags */
	int  s_value;		/* Value */
	struct	hu *howused;	/* First entry in */
};

struct sym *hashtbl[ ];		/* Hash buckets for symbol table	*/
struct sym *lookup();		/* define lookup as a function returning */

#define	B	0
#define C	1
#define D	2
#define E	3
#define H	4
#define L	5
#define M	6
#define A	7
#define PSW	6
#define SP	7
#define INR	4
#define DCR	5


/*
 * Types.
 */
#define S_UND	0		/* Undefined */
#define S_ABS	1		/* Absolute */
#define S_REG	2		/* Register */
#define S_REGP	3		/* Register pair */
#define S_ENTRY	4		/* .entry */
#define S_BYTE	5		/* .byte */
#define S_WORD	6		/* .word */
#define S_ASCII	7		/* .ascii */
#define S_ASCIZ	8		/* .asciz */
#define S_BLKB	9		/* .blkb */
#define S_OP1	10		/* Opcode */
#define S_OP2	11		/* Accumulator and Memory */
#define S_OP3	12		/* Index Register and stack */
#define S_OP4	13		/* Branch */
#define S_OP5	14		/* Jump   */
#define S_OP6	15		/* Condition codes */
#define S_OP7	16		/* limitted to extnd and indexed */
#define S_OP8	17		/* limitted to direct,extnd and indx */
#define S_OP9	18		/*					*/
#define S_OP10	19		/*					*/
#define S_OP11	20		/*					*/
#define S_EQU	21		/*					*/
#define S_SET	22		/*					*/
#define	S_NAME	23		/* Name the program listing	     */
#define S_ORG	24		/* Program section origin statement  */
#define	S_IF	100		/* IF directive			     */
#define S_ENDIF	102		/* ENDIF directive		     */
#define S_MACRO	200		/* Define a macro		     */
#define S_ENDM	202		/* Define macro end		     */

/*
 * Flags.
 */
#define SF_MDF	01		/* Multiply defined */
#define SF_ASG	02		/* Defined by assignment */
#define SF_MAC	04		/* is a MACRO definition */

/*
 * Variables.
 */
#define	TITLE_LN	40	/* Length of the title	*/
extern	struct	sym pst[];	/* Opcode table */
extern	struct	sym ust[];	/* User symbols */
extern	int	page	;	/* Current page number */
extern	int	pline	;	/* Lines on the current page */
extern	int	listmode;	/* Listing control */
extern	int	listaddr;	/* Listing control */
extern	int	entaddr;	/* .entry address */
extern	FILE	*src;		/* Source */
extern	FILE	*lst;		/* Listing */
extern	FILE	*obj;		/* Object */
extern	int	lflag;		/* -l flag */
extern	int	nflag;		/* -n flag */
extern	int	sflag;		/* -s flag		    */
extern	int	pass;		/* Which pass? */
extern	int	skip;		/* Skipping code lines      */
extern	int	inif;		/* in an if block of inif   */
extern	int	lineno;		/* Line number */
extern	char	*sptr;		/* Source pointer */
extern	char	sbuf[];		/* Source buffer */
extern	char	*cptr;		/* Listing code pointer */
extern	char	cbuf[];		/* Listing code buffer */
extern	char	*eptr;		/* Error pointer */
extern	char	ebuf[];		/* Error buffer */
extern	int	cadr;		/* Object address */
extern	int	crec;		/* Object index */
extern	char	crbf[];		/* Object buffer */
extern	struct	sym *pptr;	/* End of pst */
extern	struct	sym *uptr;	/* End of ust */
extern  char    title[];         /* Title buffer */
extern  int	errcnt;		 /* number of errors encounterd */
extern	int	optype;		/* Type of current operand    */

/*
 * Functions.
extern	struct	sym *lookup();	/* Search */



