/*
 * as85.c
 * Tables.
 */
#include <stdio.h>
#include "asm.h"

/*
 * Assorted variables.
 */
static char *as85="@(#)as85.c	1.2";

int	listmode;		/* Listing control */
int	listaddr;		/* Listing control */
int	entaddr;		/* Entry address */
FILE	*src;			/* Source */
FILE	*lst;			/* Listing */
FILE	*obj;			/* Object */
int	lflag;			/* -l flag */
int	nflag;			/* -n flag */
int	sflag;			/* -s flag */
int	pass;			/* Which pass? */
int	skip;			/* skipping code */
int	inif;			/* in an if block */
int	lineno;			/* Line number */
char	*sptr;			/* Source pointer */
char	sbuf[SRCMAX];		/* Source buffer */
char	*cptr;			/* Listing code pointer */
char	cbuf[CLMAX];		/* Listing code buffer */
char	*eptr;			/* Error pointer */
char	ebuf[ERRMAX];		/* Error buffer */
int	cadr;			/* Object address */
int	crec;			/* Object index */
char	crbf[CBMAX];		/* Object buffer */
int	errcnt;			/* error count   */
int	page;			/* current page number */
int	pline;			/* lines on the current page */
char	title[TITLE_LN+1];	/* program listing title*/
struct sym *hashtbl[ HASH ];	/* symbol table hashbuckets	*/ 

/*
 * User symbol table.
 * The first item must be '$'.
 */
struct sym ust[USERMAX] = {
	"$",	NULL,NULL,	S_ABS,		SF_ASG,	0
};

/*
 * Opcode table.
 * Also contains pseudo operations and
 * registers.
 */
struct sym pst[] = {
	"b",NULL,NULL,		S_REG,		0,	0,	NULL,
	"c",NULL,NULL,		S_REG,		0,	1,	NULL,
	"d",NULL,NULL,		S_REG,		0,	2,	NULL,
	"e",NULL,NULL,		S_REG,		0,	3,	NULL,
	"h",NULL,NULL,		S_REG,		0,	4,	NULL,
	"l",NULL,NULL,		S_REG,		0,	5,	NULL,
	"m",NULL,NULL,		S_REG,		0,	6,	NULL,
	"a",NULL,NULL,		S_REG,		0,	7,	NULL,
	"sp",NULL,NULL,		S_REG,		0,	SP,	NULL,
	"psw",NULL,NULL,		S_REG,		0,	PSW,	NULL,
	"org",NULL,NULL,		S_ORG,		0,	0,	NULL,
	"end",NULL,NULL,		S_ENTRY,	0,	0,	NULL,
	"db",NULL,NULL,		S_BYTE,		0,	0,	NULL,
	"dw",NULL,NULL,		S_WORD,		0,	0,	NULL,
	"ds",NULL,NULL,		S_BLKB,		0,	0,	NULL,
	"set",NULL,NULL,		S_SET,		0,	0,	NULL,
	"equ",NULL,NULL,		S_EQU,		0,	0,	NULL,
	"if",NULL,NULL,		S_IF,		0,	0,	NULL,
	"endif",NULL,NULL,	S_ENDIF,	0,	0,	NULL,
	"macro",NULL,NULL,	S_MACRO,	0,	0,	NULL,
	"endm",NULL,NULL,		S_ENDM,		0,	0,	NULL,
	"title",NULL,NULL,	S_NAME,		0,	0,	NULL,
	"pchl",NULL,NULL,		S_OP1,		0,	0351,	NULL,
	"ret",NULL,NULL,		S_OP1,		0,	0311,	NULL,
	"rc",NULL,NULL,		S_OP1,		0,	0330,	NULL,
	"rnc",NULL,NULL,		S_OP1,		0,	0320,	NULL,
	"rz",NULL,NULL,		S_OP1,		0,	0310,	NULL,
	"rnz",NULL,NULL,		S_OP1,		0,	0300,	NULL,
	"rm",NULL,NULL,		S_OP1,		0,	0370,	NULL,
	"rp",NULL,NULL,		S_OP1,		0,	0360,	NULL,
	"rpe",NULL,NULL,		S_OP1,		0,	0350,	NULL,
	"rpo",NULL,NULL,		S_OP1,		0,	0340,	NULL,
	"xchg",NULL,NULL,		S_OP1,		0,	0353,	NULL,
	"sphl",NULL,NULL,		S_OP1,		0,	0371,	NULL,
	"cma",NULL,NULL,		S_OP1,		0,	0057,	NULL,
	"cmc",NULL,NULL,		S_OP1,		0,	0077,	NULL,
	"daa",NULL,NULL,		S_OP1,		0,	0047,	NULL,
	"rlc",NULL,NULL,		S_OP1,		0,	0007,	NULL,
	"rrc",NULL,NULL,		S_OP1,		0,	0017,	NULL,
	"ral",NULL,NULL,		S_OP1,		0,	0027,	NULL,
	"rar",NULL,NULL,		S_OP1,		0,	0037,	NULL,
	"xthl",NULL,NULL,		S_OP1,		0,	0343,	NULL,
	"ei",NULL,NULL,		S_OP1,		0,	0373,	NULL,
	"di",NULL,NULL,		S_OP1,		0,	0363,	NULL,
	"stc",NULL,NULL,		S_OP1,		0,	0067,	NULL,
	"nop",NULL,NULL,		S_OP1,		0,	0000,	NULL,
	"hlt",NULL,NULL,		S_OP1,		0,	0166,	NULL,
	"in",NULL,NULL,		S_OP2,		0,	0333,	NULL,
	"out",NULL,NULL,		S_OP2,		0,	0323,	NULL,
	"adi",NULL,NULL,		S_OP2,		0,	0306,	NULL,
	"aci",NULL,NULL,		S_OP2,		0,	0316,	NULL,
	"sui",NULL,NULL,		S_OP2,		0,	0326,	NULL,
	"sbi",NULL,NULL,		S_OP2,		0,	0336,	NULL,
	"ani",NULL,NULL,		S_OP2,		0,	0346,	NULL,
	"xri",NULL,NULL,		S_OP2,		0,	0356,	NULL,
	"ori",NULL,NULL,		S_OP2,		0,	0366,	NULL,
	"cpi",NULL,NULL,		S_OP2,		0,	0376,	NULL,
	"mvi",NULL,NULL,		S_OP3,		0,	0006,	NULL,
	"mov",NULL,NULL,		S_OP4,		0,	0100,	NULL,
	"ldax",NULL,NULL,		S_OP5,		0,	0012,	NULL,
	"stax",NULL,NULL,		S_OP5,		0,	0002,	NULL,
	"dad",NULL,NULL,		S_OP6,		0,	0011,	NULL,
	"inx",NULL,NULL,		S_OP6,		0,	0003,	NULL,
	"dcx",NULL,NULL,		S_OP6,		0,	0013,	NULL,
	"push",NULL,NULL,		S_OP7,		0,	0305,	NULL,
	"pop",NULL,NULL,		S_OP7,		0,	0301,	NULL,
	"rst",NULL,NULL,		S_OP8,		0,	0307,	NULL,
	"add",NULL,NULL,		S_OP9,		0,	0200,	NULL,
	"sub",NULL,NULL,		S_OP9,		0,	0220,	NULL,
	"adc",NULL,NULL,		S_OP9,		0,	0210,	NULL,
	"sbb",NULL,NULL,		S_OP9,		0,	0230,	NULL,
	"ana",NULL,NULL,		S_OP9,		0,	0240,	NULL,
	"xra",NULL,NULL,		S_OP9,		0,	0250,	NULL,
	"ora",NULL,NULL,		S_OP9,		0,	0260,	NULL,
	"cmp",NULL,NULL,		S_OP9,		0,	0270,	NULL,
	"inr",NULL,NULL,		S_OP9,		0,	0004,	NULL,
	"dcr",NULL,NULL,		S_OP9,		0,	0005,	NULL,
	"lxi",NULL,NULL,		S_OP10,		0,	0001,	NULL,
	"jpo",NULL,NULL,		S_OP11,		0,	0342,	NULL,
	"jpe",NULL,NULL,		S_OP11,		0,	0352,	NULL,
	"jm",NULL,NULL,		S_OP11,		0,	0372,	NULL,
	"jp",NULL,NULL,		S_OP11,		0,	0362,	NULL,
	"jnz",NULL,NULL,		S_OP11,		0,	0302,	NULL,
	"jz",NULL,NULL,		S_OP11,		0,	0312,	NULL,
	"jnc",NULL,NULL,		S_OP11,		0,	0322,	NULL,
	"jc",NULL,NULL,		S_OP11,		0,	0332,	NULL,
	"cpo",NULL,NULL,		S_OP11,		0,	0344,	NULL,
	"cpe",NULL,NULL,		S_OP11,		0,	0354,	NULL,
	"cm",NULL,NULL,		S_OP11,		0,	0374,	NULL,
	"cp",NULL,NULL,		S_OP11,		0,	0364,	NULL,
	"cnz",NULL,NULL,		S_OP11,		0,	0304,	NULL,
	"cz",NULL,NULL,		S_OP11,		0,	0314,	NULL,
	"cnc",NULL,NULL,		S_OP11,		0,	0324,	NULL,
	"cc",NULL,NULL,		S_OP11,		0,	0334,	NULL,
	"call",NULL,NULL,		S_OP11,		0,	0315,	NULL,
	"jmp",NULL,NULL,		S_OP11,		0,	0303,	NULL,
	"lda",NULL,NULL,		S_OP11,		0,	0072,	NULL,
	"sta",NULL,NULL,		S_OP11,		0,	0062,	NULL,
	"lhld",NULL,NULL,		S_OP11,		0,	0052,	NULL,
	"shld",NULL,NULL,		S_OP11,		0,	0042,	NULL,
};

/*
 * Pointers to the end of the
 * tables.
 * Must be here!
 */
struct sym *pptr = &pst[sizeof(pst)/sizeof(pst[0])]; /* Ditto */
struct sym *uptr = &ust[1];	/* Pointer to end of ust */

