/*
 * Lex.
 */
#include <stdio.h>
#include "asm.h"
static char *sccsid="@(#)as83.c	1.2";


/*
 * Get the next non white
 * character.
 */
getnb()
{
	register int c;

	while((c=getraw())==' ' || c=='\t');
	return(c);
}

/*
 * Get next character from
 * the input.
 * Apply string mappings.
 */
getmap()
{
	register int n, c, v;

	if((c=getraw()) == '\\')
		switch(c = getraw()) {

		case 'n':
			c = '\n';
			break;

		case 'r':
			c = '\r';
			break;

		case 't':
			c = '\t';
			break;

		case 'b':
			c = '\b';
			break;

		case '0':
		case '1':
		case '2':
		case '3':
		case '4':
		case '5':
		case '6':
		case '7':
			v = n = 0;
			while(++n<=3 && c>='0' && c<='7') {
				v = 8*v + c - '0';
				c = getraw();
			}
			putback(c);
			c = v;
			break;

		default:
			putback(c);
			c = '\\';
		}
	return(c);
}

/*
 * Get next character.
 * Basic routine.
 * Don't screw up on end of
 * line.
 */
getraw()
{
	register int c;

	if((c = *sptr) != '\0')
		++sptr;
	return(c);
}

/*
 * Check for alpha.
 */
alpha(c)
register int c;
{
	return(c=='?'|| (c>='a' && c<='z') || (c>='A' && c<='Z'));
}

/*
 * Put a character back.
 * A line at a time version
 * of ungetc.
 * Die if too many characters
 * are put back.
 */
putback(c)
{
	if(c != '\0')
		if(--sptr < sbuf)
			abort();
}

/*
 * Read in an indentifier.
 * Store it (padded with nulls) into the
 * supplied buffer.
 */
getid(c, id)
register int c;
char *id;
{
	register char *p;

	p = id;
	while(alpha(c) || c== '$' || (c>='0' && c<='9')) {
		if(p < &id[NCPS]){
			if ( c>='A' && c<='Z' )
				c |=' ';
			if( c != '$' )
				*p++ = c;
		}
		c = getraw();
	}
	while(p < &id[NCPS])
		*p++ = '\0';
	putback(c);
}

/*
 * instr( c,str)
 *
 * returns the index to locate c in str if c is in str.
 * if c is not in str then returns -1.
 */

int
instr( c, str )
char c;
char *str;
{
	register char *lp;
	lp = str;
	while( *lp != '\0' )
		if( *lp++ == c )
			return( lp-str-1 );
	return( -1 );
}
char
ucase( c )
char c;
{
	if( c >= 'a' && c <= 'z')
		c = ( c - ( 'a' - 'A' ));
	return( c );
}

/*
 * get a number;
 *
 */
static  char *hexstr = "0123456789ABCDEF";
int
getnum(c)
char c;
{
	static  char *radix = "BDHOQ";		
	static int radv[]={ 10,2,10,16,8,8};
	int value;

	char numbstr[ 16 ];
	char *np;

	np = numbstr;
	while( instr( ucase( c ), hexstr) >= 0 ){
		*np++=ucase( c );
		c = getraw();
	}
	*np-- = '\0';
	if( instr( ucase( c ), radix ) < 0 ){
		putback(c );			/* if terminal not right */
		c = *np;			/* then the previous is	 */
		if( instr( ucase( c ), radix ) >= 0 )
			*np = '\0';
	}
	/*
	 * The following code uses the index into the radix array to
         * calculate the correct index into radix value table and 
	 * use the value found to determine the correct conversion 
	 * routine.
	 *
	 * Think carefully before changing the following code.
	 *
 	 */
	return( scnnumb( numbstr, radv[ 1 + instr( ucase( c ), radix )]));
}

int
scnnumb( str ,radix )
char *str;
int	radix;
{
	int v ,d;
	v = 0;
	while( *str )
		if( (d=instr( *str++, hexstr)) >= 0 && d < radix )
			v = v*radix + d;
		else
			return( err( 'N' ), 0 );
	return( v );
}
