/*
 * as81.c
 * Assemble a line.
 */
#include <stdio.h>
#include "asm.h"

static char *as81="@(#)as81.c	1.3";

/*
 * Assemble a line.
 */
asmline()
{
	register struct sym *sp,*lsp;
	register int rs, rd;
	char	*ptr;
	int	n;
	int a, c, opcode;
	char id[NCPS];

	listaddr = dot->s_value;
	listmode = skip ? NLIST : SLIST; /* if skiping then no list */
	lsp = NULL;
	c = getnb();

	do{
		if(c=='\0' || c==';' || c=='\n') 
			break;
		if( c == '!' )
			c = getnb();
		if(!alpha(c)) {
			if( !skip )
				err('L');
			break;
		}
		getid(c, id);

		if(( c = getnb()) == ':' ) {
			if( skip )
				break;
			sp=lookup(id, ust ,'d');
			if(pass==0) {
				if(sp->s_type!=S_UND &&
				    (sp->s_flag&SF_ASG)==0)
					sp->s_flag |= SF_MDF;
				sp->s_type = S_ABS;
				sp->s_value = dot->s_value;
			} 
			else {
				if((sp->s_flag&SF_MDF)!=0)
					err('L');
				if(sp->s_type!=S_ABS ||
				    sp->s_value!=dot->s_value)
					err('L');
			}
			listmode = ALIST;
			continue;
		} 
		else
			putback(c);
		if((sp=lookup(id, pst)) == NULL){
			if( !skip ){
				lsp = lookup( id, ust ,'=' );
				c = getnb();
				getid( c , id );
				if((sp = lookup( id, pst )) == NULL){
					err('O');
					break;
				}
			}
			else
				return;
		}
		else if (skip &&(sp->s_type != S_ENDIF))
			return;
		else if((skip || inif)&&(sp->s_type == S_ENDIF)) { 
			skip = 0;
			if(!(--inif))
				inif=0;
			listmode = NLIST;
			return;
		}
		listmode = CLIST;
		if( lsp != NULL ){
			switch( sp->s_type){
			case S_EQU:
			case S_SET:
				if( lsp->s_type != S_UND &&
				    ( lsp->s_flag&SF_ASG) == 0)
					err('L');
				lsp->s_type = S_ABS;
				lsp->s_flag |= SF_ASG;
				lsp->s_value = listaddr = expr();
				listmode = ALIST;	
				lsp = NULL;
				break;
			case S_MACRO:
				lsp = NULL;
				err('M');
				break;
			}
		}
		if( lsp != NULL ){
			if(pass==0) {
				if(lsp->s_type!=S_UND &&
				    (lsp->s_flag&SF_ASG)==0)
					lsp->s_flag |= SF_MDF;
				lsp->s_type = S_ABS;
				lsp->s_value = dot->s_value;
			} 
			else {
				if((lsp->s_flag&SF_MDF)!=0)
					err('L');
				if(lsp->s_type!=S_ABS ||
				    lsp->s_value!=dot->s_value)
					err('p');
			}
			lsp = NULL;
		}
		listmode = CLIST;
		opcode = sp->s_value;
		switch(sp->s_type) {

		case S_EQU:
		case S_SET:
		case S_MACRO:
			break;

		case S_IF:
			inif += 1;
			skip = (expr()==0);
			listmode = NLIST;
			return;

		case S_NAME:
			n = TITLE_LN;
			c=getnb();
			ptr = title;
			while((*ptr++ = getraw())!=c && --n>0);
			*(--ptr) = '\0';
			return;

		case S_ORG:
			listaddr = dot->s_value = expr();
			break;

		case S_ENTRY:
			entaddr = expr();
			return;

		case S_BYTE:
			do {
				if ( (c=getnb())=='\'')
					ascii(c);
				else{
					putback( c );
					a = expr();
					byte(a);
					codeb(a);
				}
			}
			while((c=getnb()) == ',');
			putback(c);
			break;

		case S_WORD:
			do {
				codew(expr());
			} 
			while((c=getnb()) == ',');
			putback(c);
			break;

		case S_BLKB:
			a = expr();
			while(a--)
				codeb(0);
			listmode = ALIST;
			break;

		case S_OP1:
			codeb(opcode);
			break;

		case S_OP2:
			a = expr();
			byte(a);
			codeb(opcode);
			codeb(a);
			break;

		case S_OP3:
			rd = getreg(S_REG);
			comma();
			a = expr();
			byte(a);
			code3(opcode, rd);
			codeb(a);
			break;

		case S_OP4:
			rd = getreg(S_REG);
			comma();
			rs = getreg(S_REG);
			codeb(opcode | rd<<3 | rs);
			break;

		case S_OP5:
			if((rd=getreg(S_REG))!=B && rd!=D)
				err('a');
			code4(opcode, rd);
			break;

		case S_OP6:
			if((rd=getreg(S_REG)) == PSW){
				err('R');
			}
			code4(opcode, rd);
			break;

		case S_OP7:
			if((rd=getreg(S_REG)) == SP)
				err('a');
			code4(opcode, rd);
			break;

		case S_OP8:
			a = expr();
			if(a<0 || a>7)
				err('t');
			code3(opcode, a&07);
			break;

		case S_OP9:
			rs = getreg(S_REG);
			if(opcode==INR || opcode==DCR)
				code3(opcode, rs);
			else
				codeb(opcode | rs);
			break;

		case S_OP10:
			if((rd=getreg(S_REG)) == PSW)
				err('a');
			comma();
			a = expr();
			code4(opcode, rd);
			codew(a);
			break;

		case S_OP11:
			a = expr();
			codeb(opcode);
			codew(a);
			break;

		default:
			err('C');
		}	/* end of case statement */
	} 
	while( ( c = getnb()) != '\0' && c != ';' );
}

/*
 * Process the body of .ascii
 * and .asciz pseudo ops.
 * The z flag is true for a
 * .asciz
 */
ascii(delim)
char delim;
{
	register int c;

	while((c=getmap())!='\0' && c!=delim)
		codeb(c);
	if(c == '\0')
		err('S');
}

/*
 * Get a register.
 * Type is either S_REG or S_REGP.
 */
getreg(type)
{
	register struct sym *sp;
	register int c;
	char id[NCPS];

	if(!alpha(c=getnb())) {
		err('R');
		putback(c);
		return(0);
	}
	getid(c, id);
	if((sp=lookup(id, pst))==NULL || type != sp->s_type) {
		err('R');
		return(0);
	}
	return(sp->s_value);
}

/*
 * Insure that the value of
 * an expression is a legal
 * byte value.
 * Error if not.
 */
byte(b)
{
	if((b&0200)!=0)
		b |= ~0377;
	if(b>127 || b<-128)
		err('R');
}

/*
 * Check for `,'.
 */
comma()
{
	if(getnb() != ',')
		err('a');
}

/*
 * Build instructions of the
 * general form xxrrrxxx.
 */
code3(x, r)
{
	codeb(x | r<<3);
}

/*
 * Build instructions of the
 * general form xxrrxxxx.
 */
code4(x, r)
{
	codeb(x | (r&6)<<3);
}
