/*
 * as82.c
 * Expressions.
 */
#include <stdio.h>
#include "asm.h"
static char *as82="@(#)as82.c	1.2";


/*
 * Read an expression.
 * Return its value.
 * All expressions are evaluated
 * left to right; parentheses
 * may be used to alter the order
 * of evaluation.
 */
int
expr()
{
	register int c;
	int l, r;

	if(!term(&l))
		return(0);
	while(validop(c=getopr())) {
		if(!term(&r)) {
			err('e');
			return(l);
		}
		switch(c) {

		case '+':
			l += r;
			break;

		case '-':
			l -= r;
			break;

		case '*':
			l *= r;
			break;

		case '/':
			l /= r;
			break;

		case '&':
			l &= r;
			break;

		case '|':
			l |= r;
			break;
		case '^':
			l ^= r;
			break;
		case '%':
			l %= r;
			break;
		case '<':
			l <<= r;
			break;
		case '>':
			l >>= r;
			break;
		}
	}
	putback(c);
	return(l);
}

/*
 * Check for valid arithmetic
 * operators.
 */
validop(c)
{
	return( instr( c,"+-*/%&|<>^") >= 0);
}

/*
 * Get a term.
 * Store its value in the
 * indicated place.
 * Return true if a term is
 * found.
 * If no term is found no
 * characters are read and
 * false is returned.
 */
int
term(vp)
int *vp;
{
	register struct sym *sp;
	register int c;
	char id[NCPS];

	/*
	 * Number.
	 */
	if((c=getnb())>='0' && c<='9') {
		*vp = getnum(c);
		return(1);
	/*
	 * Id.
	 */
	} else if(alpha(c)) {
		getid(c, id);
		if( strcmp(id,"not")== 0){ /* if the id is 'not' */
			term(vp);
			*vp = ~*vp;
		}else {
			sp = lookup(id, ust, 'e');
			if(sp == NULL )
				err( 'U');
			else if(sp->s_type == S_UND)
				err('u');
			*vp = sp->s_value;
		}
		return(1);

	/*
	 * Unary ops.
	 */
	} else if(c=='-') {
		if(!term(vp)) {
			err('e');
			return(0);
		} 
		*vp = -*vp;
	/*
	 * Parentheses.
	 */
	} else if(c == '(') {
		*vp = expr();
		if(getnb() != ')')
			err('(');
		return(1);

	/*
	 * Character constant.
	 */
	} else if(c == '\'') {
		*vp = getmap();
		if(getnb() != '\'')
		  {
			putback(c);
			*vp = *vp+(getmap()<<8);
			if(getnb() != '\'')
				err('\'');
		   }
		return(1);

	/*
	 * The current value of DOT
	 */

	} else if ( c == CDOT ){
		*vp = dot->s_value;
		return(1);

	/*
	 * None.
	 */
	} else {
		putback(c);
		return(0);
	}
}

/*
 * getopr()
 *
 * Get a valid operator.
 *
 * Finds non-unix type operators and returns them as valid
 * Unix operators.
 *
 */
getopr()
{
	char ch;
	char id[ NCPS ];
	int index;

	if( validop(ch=getnb()) )
		return(ch);
	if( alpha(ch))
		getid( ch, id);
	else
		return(ch);
	if( strcmp( id , "and") == 0)
		return('&');
	else if( strcmp( id, "or") == 0)
		return('|');
	else if( strcmp( id, "xor") == 0)
		return('^');
	else if( strcmp( id, "mod") == 0)
		return('%');
	else if( strcmp( id, "shr") == 0)
		return('>');
	else if( strcmp( id, "shl") == 0)
		return('<');
	else
		for( index = strlen(id); index==1 ;index--)
			putback( id[ index] );	
	return( id[ 0 ]);
}
