/*% cc -n -O % -o mkbin
 * MKBIN  - converts UNIX text files to CP/M text files.
 *
 *     usage: mkbin files
 *
 *   Will replace named files with converted ones.
 */

char SCCS_id[] = "@(#)mkbin.c	1.5";


#include <stdio.h>

main(argc, argv)
int argc;
char *argv[];
{
	char *mktemp();
	FILE *fopen();
	register int n = 0;
	register int i;
	register char c;
	FILE *sid;
	FILE *oid;
	int nbytes, xtra;
	char *temp;
	char ibuf[BUFSIZ];
	char obuf[BUFSIZ];

	for (i = 1; i < argc; i++) {
		nbytes = 0;
		if ((sid = fopen(argv[i], "r")) == NULL) {
			perror(argv[0]);
			continue;
		}
		setbuf(sid, ibuf);
		temp = mktemp(",binXXXXXX");
		if ((oid = fopen(temp, "w")) == NULL) {
			perror(argv[0]);
			exit(1);
		}
		setbuf(oid, obuf);
		while ((c = fgetc(sid)) != EOF) {
			if ((char)(c) == '\n') {
				fputc('\r', oid);
				nbytes++;
				fputc('\n', oid);
				nbytes++;
			} else {
				fputc((char)(c), oid);
				nbytes++;
			}
		}
		xtra = 128 - (nbytes % 128);
		for (n = 0; n < xtra; n++) {
			fputc('\032', oid);
		}
		fclose(sid);
		fclose(oid);
		if (unlink(argv[i]) != 0) {
			perror(argv[0]);
			exit(2);
		}
		if (link(temp, argv[i]) != 0) {
			perror(argv[0]);
			exit(3);
		}
		if (unlink(temp) != 0) {
			perror(argv[0]);
			exit(4);
		}
	}
	exit(0);
}
