/*  behead.c  v1.1		    ITS format file beheader */

    /* include source library files */
#include <errno.h>
#include <stdio.h>

    /* relevant lines from my include file (ferdef.h) */
typedef int		BOOLEAN;
#ifndef FALSE
#define FALSE		(0)
#endif
#ifndef TRUE
#define TRUE		(1)
#endif
#define ABORT		exit(1)
#define STOP		exit(0)
#define SCREEN		stderr
#define READ_MODE	0
#define WRITE_MODE	1

    /* include VAX Berkeley (BSDx) or PDP-11 files */
#undef NotElse
    /* check for Berkeley System V */
#ifdef BSD5
#define  NotElse
#define  BERKELEY
#endif
    /* check for Berkeley Version 7 */
#ifdef BSD7
#define  NotElse
#define  BERKELEY
extern int errno;	    /* declare external error variable */
#endif
    /* assume PDP-11 System V */
#ifndef NotElse
extern int errno;	    /* declare external error variable */
#endif

    /* define program constants */
#define PERMIT	    0644
#define BUFSIZE      512

    /* declare external functions */
char *mktemp();
char *strcpy();

main (argc, argv)		    /* ITS format file beheader */

    /* This program strips the first 4 bytes 
     *	from a file that was ftp'd from a TOPS-20
     *	machine (usually a simtel20 MICRO: directory).
     *
     * Compile line : cc -Dx behead.c -o behead
     *			where 'x' = BSD7
     *				    BSD5
     *			-Dx is not required for PDP-11
     *
     * Written by   : Ferd S. Brundick	<fsbrn@brl-voc>
     * Date written :  some time in 83
     * Modification :  1 March 84
     * 1. If only one argument is given, InFile is
     *	   copied to a temp file.  If the copy is
     *	   successful, then the temp file is renamed.
     *	  The same steps occur if InFile == OutFile.
     * 2. Rename() procedure added.
     * 3. Flags added for compilation under
     *	    Berkeley 4.2 System V
     *	    Berkeley 4.2 Version 7
     *	    PDP-11 UNIX  System V   (default)
     */
	
int  argc;
char *argv[];

{
    char    HdrStr[4];		    /* ITS header */
    char    InFile[256];	    /* name of input file */
    char    OutFile[256];	    /* name of output file */
    char    Buffer[BUFSIZE];	    /* I/O buffer */
    int     InFd;		    /* Input file descriptor */
    int     OutFd;		    /* Output file descriptor */
    int     Nbytes;		    /* number of bytes read */
    BOOLEAN SameName;		    /* TRUE iff InFile == OutFile */
    
/* check number of args */
    switch (--argc)
    {
	case 1:
	    strcpy(InFile, *++argv);
	    SameName = TRUE;
	    break;
	case 2:
	    strcpy(InFile, *++argv);
	    strcpy(OutFile, *++argv);
	    SameName = strcmp(InFile, OutFile) == 0;
	    break;
	default:
	    fprintf(SCREEN, "Usage: behead Input_file [Output_file]\07\n");
	    ABORT;
    }

/* create dummy output file name if same as InFile */
    if (SameName)
	strcpy(OutFile, mktemp("its.XXXXXX") );

/* open input file */
    if ( (InFd = open(InFile, READ_MODE) ) == -1)
    {
	fprintf(SCREEN, "Cannot open file %s\07\n", InFile);
	ABORT;
    }

/* check first 4 bytes of InFile */
    HdrStr[0] = 0x93;
    HdrStr[1] = 0x3A;
    HdrStr[2] = 0xD8;
    HdrStr[3] = 0x00;
    read(InFd, Buffer, 4);
    if (strncmp(HdrStr, Buffer, 4) != 0)
    {
	fprintf(SCREEN, "File %s does not have the 4-byte ITS header\07\n",
		InFile);
	close(InFd);
	ABORT;
    }

/* open output file */
    if ( (OutFd = creat(OutFile, PERMIT) ) == -1)
    {
	fprintf(SCREEN, "Cannot create file %s\07\n", OutFile);
	close(InFd);
	ABORT;
    }
/* copy remainder of InFile to OutFile */
    while ( (Nbytes = read(InFd, Buffer, BUFSIZE) ) > 0)
	write(OutFd, Buffer, Nbytes);
    if (Nbytes < 0)
    {
	fprintf(SCREEN, "Error in read\07\n");
	close(InFd);
	close(OutFd);
	ABORT;
    }
	
/* close files */
    close(InFd);
    close(OutFd);

/* rename new file if OutFile same as InFile */
    if (SameName)
    {
	if (Rename(OutFile, InFile) )
	{
	    fprintf(SCREEN, "ITS header stripped from file %s\n",
		    InFile);
	    STOP;
	}
	else
	{
	    fprintf(SCREEN, "ITS header stripped from file %s ", InFile); 
	    fprintf(SCREEN, "and copied to file %s\n", OutFile);
	    STOP;
	}
    }
    else
    {
	fprintf(SCREEN, "ITS header stripped from file %s ", InFile); 
	fprintf(SCREEN, "and copied to file %s\n", OutFile);
	STOP;
    }

}  /* end of main */

BOOLEAN Rename (OldName, NewName)   /* rename file */

    /* This proc tries to rename a file by linking 
     *	it to a new file, then unlinking the old file.
     * If this does not work, system("mv") is used.
     * It returns TRUE iff it works.
     */

char *OldName;			/* current name of file */
char *NewName;			/* new name of file */

{
    char Command[256];		/* string for system() command */

/* attempt to link to NewName */

try_again:
    if (link(OldName, NewName) == 0)
    { /* NewName did not exist yet */
	unlink(OldName);	/* remove link to old name */
	return(TRUE);
    }

/* determine why link failed */
    if (errno == EEXIST)
    { /* NewName already existed */
	unlink(NewName);	/* remove current file named NewName */
	goto try_again; 	/* attempt to link again */
    }
    else
    { /* attempt to use system's 'mv' command */
	sprintf(Command, "mv %s %s", OldName, NewName);
	return(system(Command) != -1);	/* -1 => failed */
    }

}  /* end of Rename */
