 # Bourne shell script

# proc 'get20' transfers a file from simtel20.
# if the user does not have a .netrc (auto-login) file,
#  one will be created for him.

# sample usage lines:
#   get20 -b cpm.modem7 mdm724.com
#   get20 -8 cpmug.vol042 resource.com resorc
#   get20 -8 sigm.vol165 nddt.doc

#   written by	 : Ferd Brundick
#   date written : some time in 1983
#   modification : 22 March 84
#     1. ftp modes are referred to as "ascii, binary, and tenex"
#	  but the ftp command "type xx" MAY be used instead because
#	  some ftp routines do not recognize the commands
#	  "ascii, binary, and tenex".  These may be changed after
#	  the comment that reads "define ftp mode commands".
#     2. The path to the ITS-format header stripper (behead) must be
#	  stored in the variable "_Behead".  Whenever a file is
#	  transferred in tenex mode, behead will be called automatically.
#	  (behead.c is available as a separate file.)
#     3. The option -8 is idential to -t for tenex (36->8) transfers.
#     4. Both parts of the directory name must be given (see examples).
#     5. Remote host name now is stored in the variable "RemoteHost".
#     6. Local host name now is stored in the variable "LocalHost" for
#	  remote login usage because the remote host would like the
#	  local host name for password.  Be sure to insert your local
#	  host name after the comment line "define host names".

# define special procs
_Behead="behead"		    # replace behead with full pathname

# define ftp mode commands
ascii="ascii"			    # 7-bit ASCII transfer
binary="binary" 		    # 8-bit binary image transfer
tenex="tenex"			    # 36 to 8-bit ITS format transfer
#"type L 8", "type local" or "type local byte" may be needed in place of 
# "tenex".  Do a "man ftp" to see how your system wants it.

# define host names
RemoteHost="simtel20.arpa"	    # .arpa suffixed is recent ARPANET change
LocalHost="xxx"			    # put your local host name here

# default mode is ascii
Mode=ascii

# check and extract options
for i
do
    case $i in
	-a) Mode=ascii
	    shift;;
	-b) Mode=binary
	    shift;;
     -[t8]) Mode=tenex
	    shift;;
	-*) echo "Unknown option -> $i"
	    echo 'get20 aborted'
	    exit 1;;
	 *) break;;
    esac
done

# check and store arguments
case $# in
    2)	RemoteFile="\"micro:<$1>$2\""
	LocalFile="$2";;
    3)	RemoteFile="\"micro:<$1>$2\""
	LocalFile=$3;;
    *)	echo 'Usage: get20 [-a|b|8] dir_name file_name [local_file_name]'
	echo 'get20 aborted'
	exit 1;;
esac

# block out interruptions
mesg n

# create ".netrc" (auto-login) file if one does not exist (or is empty)
login_file=$HOME/.netrc
test -s $login_file ||
{
echo "machine $RemoteHost, login anonymous, password $LocalHost" >$login_file
    chmod 600 $login_file		# file MUST have 0600 permissions
}

# create ftp command file
case $Mode in
     ascii) Type="$ascii";;
    binary) Type="$binary";;
     tenex) Type="$tenex";;
esac
echo "$Type
verbose
get $RemoteFile $LocalFile
bye" >ftp.get.$$

# trap aborts
trap '' 2 3

# perform file transfer
echo "$RemoteFile will be copied with $Mode mode to $LocalFile"
ftp "$RemoteHost" <ftp.get.$$
rm ftp.get.$$				# remove ftp command file
echo 'file transfer completed'

# remove ITS header bytes if transfer was done in tenex mode
if test $Mode = tenex
    then if $_Behead $LocalFile 2>/dev/null
	    then echo 'ITS header bytes removed'
	 fi
fi

# restore communications
mesg y
