set EditErrors = ask("Edit compilation errors?")
set RunMmimp = ask("Run code improver on object files?")
set NewestOFile = 0
set AnyCompiled = 0
set AnyErrors = 0
set NoLink = 0

foreach CFile in (	CKM:CKCFN2.C CKM:CKCFNS.C \
			CKM:CKCMAI.C CKM:CKMCON.C \
			CKM:CKMFIO.C CKM:CKMPRO.C \
			CKM:CKMREM.C CKM:CKMSAV.C \
			CKM:CKMSCR.C CKM:CKMSFP.C \
			CKM:CKMTIO.C CKM:CKMUSR.C \
			CKM:CKMUTL.C )
    {
    print $CFile
    set OFile = upto($CFile,".") >< ".o"
    if (!exists($OFile) || mdate($CFile) > mdate($OFile))
	{
	set AnyCompiled = 1
	Megamax_C:mmcc $CFile
	if (status() == 2)
	    {
	    set AnyErrors = 1
	    if ($EditErrors)
		Megamax_C:Editor Megamax_C:errors.out $CFile
	    }
	if (exists($OFile))
	    {
	    if ($RunMmimp)
		{
		Megamax_C:mmimp $OFile
		if (status() == 2)
		    {
		    set AnyErrors = 1
		    if (!exists($OFile))
			set NoLink = 1
		    }
		}
	    }
	else
	    {
	    set AnyErrors = 1
	    set NoLink = 1
	    }
	}
    if (exists($OFile))
	if (mdate($OFile) > $NewestOFile)
	    set NewestOFile = mdate($OFile)
    }

if ($NoLink)
    print "CKM:CKMKER not being linked due to previous errors."
else if ($AnyCompiled ||	\
    !exists(CKM:CKMKER) ||	\
    $NewestOFile > mdate(CKM:CKMKER))
    {
    if ($AnyErrors)
	set AnyErrors = ~ask("Link CKM:CKMKER after previous errors?")
    if (!$AnyErrors)
	Megamax_C:mmlink \
	    CKM:CKCFN2.o CKM:CKCFNS.o \
	    CKM:CKCMAI.o CKM:CKMCON.o \
	    CKM:CKMFIO.o CKM:CKMPRO.o \
	    CKM:CKMREM.o CKM:CKMSAV.o \
	    CKM:CKMSCR.o CKM:CKMSFP.o \
	    CKM:CKMTIO.o CKM:CKMUSR.o \
	    CKM:CKMUTL.o -o CKM:CKMKER
    }
else
    print "CKM:CKMKER is up to date."

