/* Version 0.8(35) - Jim Noble at Planning Research Corporation, June 1987. */
/* Ported to Megamax native Macintosh C compiler. */

/* Symbol Definitions */
     
#define TRUE      1      		/* Boolean constants */
#define FALSE     0
#define NIL 	  0
#define NULL	  0
#define NILPTR	(Ptr) NIL
#define NILPROC (ProcPtr) NIL
#define VIS       1       		/* Sets window visisble */
#define ALLTYPES -1			/* All types for SFGetFile */

#define MYBUFSIZE   2048		/* Serial driver replacement buffer */

#define SCR_WREF 1			/* reference # for screen window */
#define TAB_WREF 2			/* # for the tabs window */
#define CTR_WREF 3			/* # for the control window */
#define RCD_WREF 4			/* remote command display window */

#define OKBtn	ok 			/* OK and Cancel constants */ 
#define QuitBtn	cancel 			/* Defined by Dialog Mgr */

#define btnOff	0
#define btnOn	1

/* settings for parity */

#define MPARITY_ODD (oddParity+stop10+data7)
#define MPARITY_EVEN (evenParity+stop10+data7)
#define MPARITY_MARK (noParity+stop20+data7)
#define MPARITY_SPACE (noParity+stop10+data8)
#define MPARITY_NONE MPARITY_SPACE

#define KPARITY_ODD 'o'
#define KPARITY_EVEN 'e'
#define KPARITY_MARK 'm'
#define KPARITY_SPACE 's'
#define KPARITY_NONE 0

typedef struct {			/* file arguments since Kermit */
  char fillcl[64],filrem[64];		/*  doesn't pass all the info */
  int filflg;				/*  we need... */
  int fildflg;				/* default flags */
  INTEGER filvol;			/* file volume */
  int filfldr;				/* file folder for new files */
  LONGINT filsiz;			/* size of file after open */
} FILINF;

/* Flags in filflg, fildflg */

#define FIL_BINA 1
#define FIL_TEXT 2
#define FIL_RSRC 4
#define FIL_DATA 8
#define FIL_OKILL 16			/* same as kermit's !warn */
#define FIL_DODLG 32			/* show dialogs on recv */

#define FIL_RBDT (FIL_RSRC | FIL_BINA | FIL_DATA | FIL_TEXT)


/* Globals Kermit variables */

extern char *cmarg,		/* pointer to cmd argument (file) */
      	    *cmarg2,		/* pointer to second cmd argument */
	    mypadc,		/* padding char to ask for */
	    padch,
	    eol,		/* end of line char to send */
	    seol,
	    mystch,		/* outbound packet start character */
	    stchr,
	    sstate;		/* kermit protocol state */

extern long
      	    ffc;		/* file character count  */

extern int speed,		/* speed of port */
      	   parity,		/* current parity setting */
	   duplex,		/* TRUE if full duplex */
	   binary,		/* TRUE if file mode is binary */
	   displa,		/* TRUE for calls to screen() */
	   bctr;		/* block check type (1, 2, or 3) */
	   delay,		/* initial delay before sending */
	   mypadn,		/* something to do with padding */
	   npad,
	   timint,		/* timeout interval in seconds */
	   rtimo,
	   spsiz,		/* max packet size we send */
	   rpsiz,
	   turnch,		/* line "turnaround" character */
	   turn,		/* if TRUE "turnaround" enabled */
	   quiet,		/* if TRUE screen() should be quiet */
	   nfils,		/*  */
	   warn,		/* TRUE does name conversion, else */
				/*   deletes duplicate names on recv */
	   server,    	  	/* TRUE if we are in server mode */
	   cxseen,		/* if TRUE abort file */
	   czseen;		/* if TRUE abort group */

/* Mac global variables */

extern int innum,			/* serial line input number */
      	   outnum;			/* serial line output number */

extern int protocmd;			/* current cmd that made us enter */
					/*  protocol or 0 if protocol is */
					/*  not running, or -1 if remote cmd */
extern FILINF filargs;			/* file information flags */

