#include <stdio.h>
#include <ctype.h>
#include <time.h>
#include <string.h>

#define PRT	(void)printf
#define FPR	(void)fprintf

char *words[100];	/* maximum number of words on a line */
char lbuf[512];		/* maximum line size */

char *months[] = {	/* used to match alpha months */
	"jan", "feb", "mar", "apr", "may", "jun",
	"jul", "aug", "sep", "oct", "nov", "dec",
	(char *)0,
};

/*
 * pheader - provides the PostScript routines
 */
char *pheader[] = {
  "%!",
  "/titlefont /Times-Bold def",
  "/dayfont /Helvetica-Bold def",
  "/month_names [ (January) (February) (March) (April) (May) (June) (July)",
  "\t\t(August) (September) (October) (November) (December) ] def",
  "/prtnum { 3 string cvs show} def",
  "/drawgrid {\t\t% draw calendar boxes",
  "\tdayfont findfont 10 scalefont setfont",
  "\t0 1 6 {",
  "\t\tdup dup 100 mul 40 moveto",
  "\t\t[ (Sunday) (Monday) (Tuesday) (Wednesday) (Thursday) (Friday) (Saturday) ] exch get",
  "\t\t100 center",
  "\t\t100 mul 35 moveto",
  "\t\t1.0 setlinewidth",
  "\t\t0 1 5 {",
  "\t\t\tgsave",
  "\t\t\t100 0 rlineto ",
  "\t\t\t0 -80 rlineto",
  "\t\t\t-100 0 rlineto",
  "\t\t\tclosepath stroke",
  "\t\t\tgrestore",
  "\t\t\t0 -80 rmoveto",
  "\t\t} for",
  "\t} for",
  "} def",
  "/drawnums {\t\t% place day numbers on calendar",
  "\tdayfont findfont 30 scalefont setfont",
  "\t/start startday def",
  "\t/days ndays def",
  "\tstart 100 mul 5 add 10 rmoveto",
  "\t1 1 days {",
  "\t\t/day exch def",
  "\t\tgsave",
#ifndef SATBLK
  "\t\tday start add 7 mod 0 eq",
  "\t\t{",
  "\t\t\tsubmonth 0 eq",
  "\t\t\t{",
  "\t\t\t\t.8 setgray",
  "\t\t\t} if",
  "\t\t} if",
#endif
  "\t\tday start add 7 mod 1 eq",
  "\t\t{",
  "\t\t\tsubmonth 0 eq",
  "\t\t\t{",
  "\t\t\t\t.8 setgray",
  "\t\t\t} if",
  "\t\t} if",
  "\t\tday prtnum",
  "\t\tgrestore",
  "\t\tday start add 7 mod 0 eq",
  "\t\t{",
  "\t\t\tcurrentpoint exch pop 80 sub 5 exch moveto",
  "\t\t}",
  "\t\t{",
  "\t\t\t100 0 rmoveto",
  "\t\t} ifelse",
  "\t} for",
  "} def",
  "/drawfill {\t\t% place fill squares on calendar",
  "\t/start startday def",
  "\t/days ndays def",
  "\t0 35 rmoveto",
  "\t1.0 setlinewidth",
  "\t0 1 start 1 sub {",
  "\t\tgsave",
  "\t\t.9 setgray",
  "\t\t100 0 rlineto ",
  "\t\t0 -80 rlineto",
  "\t\t-100 0 rlineto",
  "\t\tclosepath fill",
  "\t\tgrestore",
  "\t\t100 0 rmoveto",
  "\t} for",
  "\tsubmonth 1 eq",
  "\t{",
  "\t\t/lastday 42 def",
  "\t\t600 -365 moveto",
  "\t}",
  "\t{",
  "\t\t/lastday 40 def",
  "\t\t400 -365 moveto",
  "\t} ifelse",
  "\tlastday -1 ndays start 1 add add",
  "\t{",
  "\t\t/day exch def",
  "\t\tgsave",
  "\t\t.9 setgray",
  "\t\t100 0 rlineto ",
  "\t\t0 -80 rlineto",
  "\t\t-100 0 rlineto",
  "\t\tclosepath fill",
  "\t\tgrestore",
  "\t\tday 7 mod 1 eq",
  "\t\t{",
  "\t\t\t600 -365 80 add moveto",
  "\t\t}",
  "\t\t{",
  "\t\t\t-100 0 rmoveto",
  "\t\t} ifelse",
  "\t} for",
  "} def",
  "/isleap {\t\t% is this a leap year?",
  "\tyear 4 mod 0 eq\t\t% multiple of 4",
  "\tyear 100 mod 0 ne \t% not century",
  "\tyear 1000 mod 0 eq or and\t% unless it's a millenia",
  "} def",
  "/days_month [ 31 28 31 30 31 30 31 31 30 31 30 31 ] def",
  "/ndays {\t\t% number of days in this month",
  "\tdays_month month 1 sub get",
  "\tmonth 2 eq\t% Feb",
  "\tisleap and",
  "\t{",
  "\t\t1 add",
  "\t} if",
  "} def",
  "/startday {\t\t% starting day-of-week for this month",
  "\t/off year 2000 sub def\t% offset from start of epoch",
  "\toff",
  "\toff 4 idiv add\t\t% number of leap years",
  "\toff 100 idiv sub\t% number of centuries",
  "\toff 1000 idiv add\t% number of millenia",
  "\t6 add 7 mod 7 add \t% offset from Jan 1 2000",
  "\t/off exch def",
  "\t1 1 month 1 sub {",
  "\t\t/idx exch def",
  "\t\tdays_month idx 1 sub get",
  "\t\tidx 2 eq",
  "\t\tisleap and",
  "\t\t{",
  "\t\t\t1 add",
  "\t\t} if",
  "\t\t/off exch off add def",
  "\t} for",
  "\toff 7 mod\t\t% 0--Sunday, 1--monday, etc.",
  "} def",
  "/center {\t\t% center string in given width",
  "\t/width exch def",
  "\t/str exch def width str ",
  "\tstringwidth pop sub 2 div 0 rmoveto str show",
  "} def",
  "/calendar",
  "{",
  "\ttitlefont findfont 48 scalefont setfont",
  "\t0 60 moveto",
  "\t/month_name month_names month 1 sub get def",
  "\tmonth_name show",
  "\t/yearstring year 10 string cvs def",
  "\t700 yearstring stringwidth pop sub 60 moveto",
  "\tyearstring show",
  "\t0 0 moveto",
  "\tdrawnums",
  "\t0 0 moveto",
  "\tdrawfill",
  "\t0 0 moveto",
  "\tdrawgrid",
  "} def",
  "/daytext {",
  "\t/Helvetica-Narrow findfont 6 scalefont setfont",
  "\t/mytext\texch def /myday exch def",
  "\tstartday myday 1 sub add dup 7 mod 100 mul 5 add % gives column",
  "\texch 7 idiv -80 mul % gives row",
  "\tdup /ypos exch def moveto",
  "\t/LM currentpoint pop def /RM LM 95 add def",
  "        mytext { dup (.p) eq { crlf pop} {prstr ( ) show} ifelse } forall",
  "} def",
  "/crlf {",
  "    ypos 8 sub /ypos exch def LM ypos moveto",
  "} def",
  "/prstr {",
  "    dup stringwidth pop currentpoint pop",
  "    add RM gt {crlf} if show",
  "} def",
  "/printmonth {",
  "\t90 rotate",
  "\t50 -120 translate",
  "\t/submonth 0 def",
  "\tcalendar",
  "\tmonth 1 sub 0 eq",
  "\t{",
  "\t\t/lmonth 12 def",
  "\t\t/lyear year 1 sub def",
  "\t}",
  "\t{",
  "\t\t/lmonth month 1 sub def",
  "\t\t/lyear year def",
  "\t} ifelse",
  "\tmonth 1 add 13 eq",
  "\t{",
  "\t\t/nmonth 1 def",
  "\t\t/nyear year 1 add def",
  "\t} ",
  "\t{",
  "\t\t/nmonth month 1 add def",
  "\t\t/nyear year def",
  "\t} ifelse",
  "\t/savemonth month def",
  "\t/saveyear year def",
  "\t/submonth 1 def",
  "\t/year lyear def",
  "\t/month lmonth def",
  "\tgsave",
  "\t500 -365 translate",
  "\tgsave",
  "\t.138 .138 scale",
  "\t10 -120 translate",
  "\tcalendar",
  "\tgrestore",
  "\t/submonth 1 def",
  "\t/year nyear def",
  "\t/month nmonth def",
  "\t100 0 translate",
  "\tgsave",
  "\t.138 .138 scale",
  "\t10 -120 translate",
  "\tcalendar",
  "\tgrestore",
  "\t/month savemonth def",
  "\t/year saveyear def",
  "\t/submonth 0 def",
  "\tgrestore",
  "} def",
  (char *)0,
};

FILE *cfp = NULL;
int year;
int cyear;

void exit();
char *getenv();

main(argc, argv)
int argc;
char **argv;
{
	extern char *optarg;
	extern int optind;
	register struct tm *lt;
	register char **ap;
	register char *cp;
	char *cfile = NULL;
	char cbuf[80];
	long t, time();
	int errflg = 0;
	int nocal = 0;
	int m;

	while ((m = getopt(argc, argv, "ef:")) != EOF)

		switch (m) {

		case 'e':
			nocal++;
			cfile = NULL;
			break;

		case 'f':
			cfile = optarg;
			nocal = 0;
			break;

		case '?':
			errflg = 1;
			break;
		}
	if (errflg) {
		FPR(stderr, "Usage: pcal [ -e | -f <cal> ] [ month [ year ]]\n");
		exit(1);
	}
	t = time((long *)0);
	lt = localtime(&t);

	/*
	 * First argument should be a month
	 */
	if ((argc - optind) > 0) {
		if ((m = atoi(argv[optind])) < 1 || m > 12) {
			FPR(stderr, "Month must be in range 1 - 12\n");
			exit(1);
		}
	} else	/* otherwise, use current month */
		m = lt->tm_mon + 1;

	/*
	 * More than one arg, second must be a year
	 */
	if ((argc - optind) > 1) {
		if ((year = atoi(argv[optind+1])) < 100)
			year += 1900;
	} else
		year = lt->tm_year + 1900;

	/*
	 * In case we don't encounter any year data in the
	 * calendar file, assume the current year.
	 */
	cyear = year;

	/*
	 * Open a supplied calendar file (if any)
	 */
	if (cfile != NULL) {
		if ((cfp = fopen(cfile, "r")) == NULL) {
			FPR(stderr, "pcal: can't open file: %s\n", cfile);
			exit(1);
		}
	}
	/*
	 * Else see if a calendar file exists in the home directory
	 */
	else if (nocal == 0 && (cp = getenv("HOME")) != NULL) {
		(void)strcpy(cbuf, cp);
		(void)strcat(cbuf, "/calendar");
		cfp = fopen(cbuf, "r");
	}
	/*
	 * Write out PostScript prolog
	 */
	for (ap = pheader; *ap; ap++)
		PRT("%s\n", *ap);

	pmonth(m);

	return(0);
}

/*
 * pmonth - do calendar for month "m"
 */
pmonth(m)
int m;
{
	register char **s;
	register oldday = -1;
	register day;

	/*
	 * Do the calendar
	 */
	PRT("/year %d def\n", year);
	PRT("/month %d def\n", m);
	PRT("printmonth\n");

	/*
	 * Browse through the calendar file looking for day info
	 */
	if ((day = getday(m)) == 0) {	/* no info */
		PRT("showpage\n");
		return;
	}
	do {
		if (day != oldday) {
			if (oldday == -1)
				PRT("%d [ \n", day);
			else
				PRT(" ] daytext %d [  \n", day);
			oldday = day;
		} else
			PRT("(.p)\n");
		for (s = words; *s; s++)
			PRT("(%s)\n", *s);

	} while (day = getday(m));
	PRT("] daytext\n");
	PRT("showpage\n");
}

/*
 * getday - find next day entry for desired month in the calendar file
 */
getday(m)
register m;
{
	static mon = 0;
	static eof = 0;
	register char *cp;
	register c;

	if (cfp == NULL)	/* whoops, no calendar file */
		return(0);

	if (m != mon) {		/* new month, rewind */
		rewind(cfp);
		eof = 0;
		mon = m;
	}
	if (eof)
		return(0);
nextline:
	cp = lbuf;
	do {
		while ((c = getc(cfp)) != '\n' && c != EOF) {
			/* ignore leading white space */
			if (cp == lbuf && (c == ' ' || c == '\t'))
				continue;
			*cp++ = c;
		}
		if (c == EOF) {
			eof = 1;
			return(0);
		}
	} while (cp == lbuf);	/* ignore empty lines */
	*cp = 0;

	/* examine the line, see if its one we want */
	if ((c = parse(m)) == 0)
		goto nextline;

	return(c);
}

/*
 * parse - check calendar entry for desired month, break line into fields
 */
parse(m)
register m;
{
	register char *cp;
	register i;

	cp = strtok(lbuf, " \t");	/* get first field */
	while (*cp) {
		if (isupper(*cp))
			*cp = tolower(*cp);
		cp++;
	}
	cp = lbuf;

	/*
	 * Check for "year" line
	 */
	if (strcmp(cp, "year") == 0) {
		cp = strtok((char *)0, " \t");
		if ((i = atoi(cp)) > 0) {
			if (i < 100)
				i += 1900;
			cyear = i;
		}
		return(0);
	}
	/*
	 * If field begins with alpha, try to decode month name
	 */
	if (isalpha(*cp)) {
		if (cyear != year)
			return(0);

		for (i = 0; months[i]; i++)
			if (strncmp(cp, months[i], 3) == 0) {
				if (++i != m)
					return(0);

				/* month found, get day */

				if ((cp = strtok((char *)0, " \t")) == NULL)
					return(0);
				if ((i = atoi(cp)) < 1 || i > 31)
					return(0);
				if (loadwords())
					return(i);
				return(0);
			}
		return(0);
	}
	/*
	 * Not alpha month, try numeric
	 */
	if ((i = atoi(cp)) != m)
		return(0);
	while (isdigit(*cp))
		cp++;
	while (*cp && !isdigit(*cp))
		cp++;

	/* now get day */

	if ((i = atoi(cp)) < 1 || i > 31)
		return(0);

	 /* Numeric dates may have a year */

	while (isdigit(*cp))
		cp++;
	while (*cp && !isdigit(*cp))
		cp++;
	if ((m = atoi(cp)) > 0) {
		if (m < 100)
			m += 1900;
		cyear = m;
	}

	if (cyear != year)
		return(0);

	if (loadwords())
		return(i);
	return(0);
}

/*
 * loadwords - tokenize line buffer into word array
 */
loadwords()
{
	register char **ap = words;
	register i;

	for (i = 0; *ap = strtok((char *)0, " \t"); ap++, i++);
	return(i);
}
