month(1)

NAME
	month - a visual monthly calendar and time/event browser

SYNOPSIS
	month [-d]

DESCRIPTION

    Overview

	Month displays a calendar of the current month of the current year,
	with the current day highlighted.  It then allows the user to browse
	to any month/day/year he chooses, and to schedule and recall events
	for a day or for some regular repeating series of days.

    Screen Areas

	There are four distinct areas of the screen.  The days area where
	the days of the month are listed in calendar format, the months area
	where the months of the year are listed, the years area where a
	sequence of years are listed, and the schedule area, which may be
	blank and occupies lines 19-24 on the terminal. (lines below 24 are
	not used)

    Commands
	
	Quitting
		You may type 'Q' almost any time to quit.  This will update
		your event database if you have made any changes.
		Your event database is a file called ".month" in your
		home directory.
		Control-c or Control-\ can be used any time for immediate
		abort and no event database update.
		Any time you quit in any of these ways, you will be informed
		of whether your event database has been updated.

	Cursor motion

	    'h', 'l', 'k', and 'j' are used to move the cursor left, right,
	    up and down respectively within a screen area.  In some cases,
	    explained later, 'j' and 'k' will not work, and a <TAB> or <CR>
	    is used to move between fields in a wrap-around fashion.

	Selection

	    <CR> and <LF> are used to select items/commands at the cursor
	    position.
	
	Direct entry of numbers

	    The user may type the number of a desired month, day, or year
	    whenever the cursor is appropriately positioned.  This is
	    true in all screen areas.  <ESC> is used to abort the function.
	
	Scrolling numbers

	    In the schedule area, numbers may be scrolled forwards and
	    backwards with the <SPACE> and <BACKSPACE> keys respectively.
	    This is the only way to change hours and minutes.
	
	Time browsing

	    'm', 'd' and 'y' are used to move into the months area, the
	    days area or the years area respectively.  This is only when
	    time browsing in these three panes.  To get to a particular
	    month or year, move to the appropriate area and onto the
	    desired month or year, and select it. (<CR>)  Years may be
	    scrolled a year at a time by using the scroll areas marked
	    by '<<' and '>>'.  Attempting to move passed these areas will
	    scroll by one year, selecting them scrolls by ten years.
	    The last month of the previous year, or the first month of
	    next year, may be obtained by selecting the area above
	    January or below December respectively.  The cursor is the
	    positioned for immediate return via a subsequent selection.

	    'n' and 'p' can be used to go to the next or previous month,
	    day, or year, depending on which screen area you are in.

	    'M' is used to mark a specific date.  You will be prompted for
	    an identifier which is a single digit between '0' and '9'.
	    Once a mark has been set at a certain date, you may jump to
	    that date from any other date with the command below.

	    'G' is used to go to a previously set mark.  You will be
	    prompted for the mark's identifying digit.

	    ';' is used to go directly to the last date you viewed which
	    was in a different month than currently displayed.  Use the
	    same command again to return to where you were originally.

	    'T' is used to go directly the actual, real current date, which
		is the date initially displayed upon startup.

		'/' is used to go directly to a date to be fully specified by
		the user.  A prompt is given to which the user responds with
		a date in the form m/d/y, such as 5/6/86.  Years less than
		100 are assumed to be in this century, hence, 5/6/80 is the
		same as 5/6/1986.
	
	Overviewing a day

	    'O' will fill the schedule area with a read only view
	    of your day according to your event database.  Four
	    six-hour grids appear showing which hours of the
	    day have been pre-scheduled.  The cursor must be placed
	    on the day to be viewed with this function.

	Overviewing a month

	    'A' will mark all the days on the calendar that have
	    at least one event posted.  This feature is especially
	    useful before scanning; described next.

	Scanning events

		'S' will cause a sequential list of events for the current day
		to be displayed in the schedule area.  The events for any given
		day may be scanned, deleted, or modified.
	    After displaying each one, the prompt "[n,p,d,e,q]" is put
	    up and will respond to these character commands:

		'n': go to next event
		'p': go to previous event
		'd': delete this event
		'e': edit this event as during a posting described below
		'q': quit the scan and return to calendar
		<ESC>: same as 'q'

	Every event scan

	    'E' will display, one at a time, absolutely every event
	    in your event database.  The prompt "['n','q']" is displayed
	    and will respond to these character commands:

		'n': go to next event
		'q': quit the scan and return to calendar
		<ESC>: same as 'q'
	
	Posting an event

	    'P' is the command used to post an event.  The
	    cursor is placed into the schedule area with a host of
	    information displayed.  To discontinue, use <ESC> or
	    select CANCEL.  The cursor first appears on the first
	    line of the schedule area.  This line gives the starting
	    date for the event, and when it shall occur.  The user
	    may move into the starting date and change the month,
	    day and year by scrolling with <SPACE> and <BACKSPACE>,
	    or by directly typing it.  The other fields in this
	    first line may be moved onto and selected.  <TAB> will
	    move the cursor to the next line which contains the
	    time at which the event occurs.  'h' and 'l' move between
	    the hours and minutes fields which may be scrolled.  The
	    AM/PM indicator changes as the hours scroll across
	    12:00 boundaries.  <TAB> will move the cursor to the
	    next line which gives the duration of the event, and
	    it is edited in the same fashion.  <TAB> moves the cursor
	    to the next line which is a one line description of the
	    event, to be typed whenever the cursor is placed here.
	    <TAB> moves to the last line in the schedule area which
	    allows the user to select ACCEPT or CANCEL.  Selecting
	    ACCEPT will put the event into the user's event database,
	    after being asked if he really wants it to be.  Selecting
	    CANCEL aborts the process.  <TAB> returns to the first
	    line.

	    Event scheduling

		When and how often will an event occur?  This information
		is contained in the first line of the schedule area.  The
		date entered there is the starting date for the event,
		that is, the event will not be recalled until that date.
		This date is best entered by browsing to it, placing the
		cursor in the days area on the desired day, and then
		type 'P' to post the event, in which case the desired date
		automatically appears as the default, but may be edited.
		In the following examples, only the fields that need to be
		selected are mentioned, all others should be turned off.
		(not highlighted)  Examples:

		March 5, 1990 (once only)
		    3/5/1990
		
		Every Tuesday and Wednesday
		    m/d/y every TueWed
		
		The 7th of each month
		    m/7/y monthly
		
		Each July 4th

		    7/4/y yearly

		The 2nd and last sunday of each month
		    m/d/y monthly every 2nd last Sun

		The 1st and last friday of each year
		    m/d/y yearly every 1st last Fri

		Every other thursday
		    m/d/y every 2nd Thu
		    Note, this will include the 1st, 3rd, 5th, 7th, etc.
		    thursday, starting from the specified m/d/y

	Miscellaneous

	    'L' stands for lunar, and causes a picture of what the moon will
	    look like at 11:00PM on the day on which the cursor is placed.
		'^L' or '^R' will redraw the screen.

OPTIONS
	Specifying the -d flag causes a background daemon to be born that
	will wake up at 15 minute intervals during the current login
	session, check your event database, and print a message to your
	terminal with a bell if it finds an event that is 15 minutes, or
	less, away.  It will do this check upon invocation, then wake up
	on every 15-minute clock division until killed or you log out.

CAVEATS/BUGS
	Very few attempts have been made to prevent the user from browsing
	through negatively numbered years or years with more than four
	digits in them, the latter causing the years area to get messed up,
	but remains functional.
	In rare cases, events with a starting date before the year 1753,
	will not be recalled correctly.

FILES
	$HOME/.month
