#define ERROR	-1
#define READERR	0

#define	BEG	0
#define	CURR	1
#define	END	2
#define	READ	0
#define	WRITE	1
#define	UPDATE	2

#define	OKCLOSE	0
#define	FILESIZE	65000L
#define	COUNT	500

#define	C	13849L
#define	A	25173L
#define	ODDNUM	23
#define	REG
long	seed = 7L;

long	random(), lseek();

main(argc, argv)
int	argc;
char	*argv[];
{
	int	i;
	REG long	j;
	long		pos;
	int	fd;
	char	buffer[512];

	if (argc == 1) argv[1] = "rfile";
	if ((fd = creat(argv[1], 0666)) == ERROR)
		abort("Can't create data file\n");
	else	printf("File opened for sequential writing\n");
	for (j = 0; j < sizeof(buffer); ++j) buffer[j] = 'x';
	for (j = FILESIZE; j > 0; j -= sizeof(buffer))
		if (write(fd, buffer,  (j > 512) ? 512 : j) == ERROR)
			abort("Unexpected EOF in writing data file\n");
	if (close(fd) != OKCLOSE)
		abort("Error closing data file\n");
	else
		printf("Normal termination writing data file\n");
	if ((fd = open(argv[1], UPDATE)) == ERROR)
		abort("Can't open data file for random reading and writing\n");
	else	printf("File opened for random reading and writing\n");
	for (i = 0; i < COUNT; ++i)
	{
		j = random(FILESIZE);
		if (j < 0L)
			j = -j;
		if (FILESIZE - j < ODDNUM)
			continue;
		if ((pos = lseek(fd, j, BEG)) == -1L)
			abort("Error seeking to random offset\n");
		if (read(fd, buffer, ODDNUM) == READERR)
			abort("Error reading at random offset\n");
		j = random(FILESIZE);
		if (j < 0L)
			j = -j;
		if (FILESIZE - j < ODDNUM)
			continue;
		if ((pos = lseek(fd, j, BEG)) == -1L)
			abort("Error seeking to random offset\n");
		if (write(fd, buffer, ODDNUM) == READERR)
			abort("Error writing at random offset\n");
	}
	if (close(fd) != OKCLOSE)
		abort("Error closing data file\n");
	else
		printf("Normal termination from random reading and writing\n");
	exit(0);
}

long	random(size)
long	size;
{
	seed = seed * A + C;
	return (seed % size);
}
abort(message)
char	*message;
{
	printf(message);
	exit(ERROR);
}
