###############################################################################
#  The BYTE UNIX Benchmarks - Release 2
#          Module: dhry.awk   SID: 2.3 4/17/90 16:45:41
#          
###############################################################################
# Bug reports, patches, comments, suggestions should be sent to:
#
#	Ben Smith or Rick Grehan at BYTE Magazine
#	ben@bytepb.UUCP    rick_g@bytepb.UUCP
#
###############################################################################
#  Modification Log:
#        added geometric mean 8/6/89 -ben
#
###############################################################################
BEGIN { FS=":"; tsum = 0.000; t2sum = 0.000; t_product = 0.0000;
	dsum = 0.000; d2sum = 0.000; d_product = 0.0000;
	iter = 0;
	}
/real/	{ next }  # don't use these times
/user/	{ next }
/sys/	{ next }
/^$/	{ next } 
/^Microseconds/ { 
	t=$2; 
	tsum += t;
	t2sum += t*t;
	if (t) { t_product += log(t); }
        }
/^Dhrystones/ { 
	d=$2; 
	dsum += d;
	d2sum += d*d;
	if (t) { d_product += log(d); }
	iter ++;
        }
END {
	if (iter > 0) { 
	    printf "                       Arithmetric        Geometric         Variance\n";
	    printf "                              Mean             Mean         (%d tests)\n",iter
	    printf "Microseconds/loop:       %9.0f        %9.0f         ",tsum/iter,exp(t_product/iter);
	    if (iter > 1) printf "%9.2f\n",(t2sum-tsum*tsum/iter)/(iter-1);
	    else printf "n/a\n"
	    printf "Dhrystones/sec:          %9.0f        %9.0f         ",dsum/iter,exp(d_product/iter);
	    if (iter > 1) printf "%9.2f\n",(d2sum-dsum*dsum/iter)/(iter-1);
	    }
	else { 
	    print " -- no measured results --"; 
	    }
    }
