/*******************************************************************************
 *  The BYTE UNIX Benchmarks - Release 2
 *          Module: fstime.c   SID: 2.8 4/17/90 16:45:33
 *          
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Ben Smith or Rick Grehan at BYTE Magazine
 *	bensmith@bixpb.UUCP    rick_g@bixpb.UUCP
 *
 *******************************************************************************
 *  Modification Log:
 * $Header: fstime.c,v 3.4 87/06/22 14:23:05 kjmcdonell Beta $
 * 10/19/89 - rewrote timing calcs and added clock check (Ben Smith)
 * 10/26/89 - simplify timing, change defaults (Tom Yager)
 * 11/16/89 - added better error handling and changed output format (Ben Smith)
 * 11/17/89 - changed the whole thing around (Ben Smith)
 ******************************************************************************/
char SCCSid[] = "@(#) @(#)fstime.c:2.8 -- 4/17/90 16:45:33";

#include <stdio.h>
#include <signal.h>
#include <errno.h>

#define SECONDS 10
#define BUFF_SIZE 1024

/****************** GLOBALS ***************************/
char buf[BUFF_SIZE];
int			seconds = SECONDS;
int			f;
int			g;
int			i;
int			stop_count();
int			clean_up();
int			sigalarm = 0;

/******************** MAIN ****************************/

main(argc, argv)
char **argv;
{

/**** initialize ****/
    if (argc > 1)
	seconds = atoi(argv[1]);
    if (argc == 3 && chdir(argv[2]) == -1) 
	    {
	    perror("fstime: chdir");
	    exit(1);
	    }
    if((f = creat("dummy0", 0600)) != -1)
            close(f);
    else
	    {
	    perror("fstime: creat");
	    exit(1);
	    }
    if((g = creat("dummy1", 0600)) != -1)
            close(g);
    else
	    {
	    perror("fstime: creat");
	    exit(1);
	    }
    if((f = open("dummy0", 2)) == -1)
	    {
	    perror("fstime: open");
	    exit(1);
	    }
    if((g = open("dummy1", 2)) == -1)
	    {
	    perror("fstime: open");
	    exit(1);
	    }
    /* fill buffer */
    for (i = 0; i < BUFF_SIZE; i++)
	buf[i] = i & 0177;
    /*** run the tests ****/
    signal(SIGKILL,clean_up);
    if(w_test())
	{
	clean_up();
	exit(1);
	}
    if(r_test())
	{
	clean_up();
	exit(1);
	}
    if(c_test())
	{
	clean_up();
	exit(1);
	}
    clean_up();
    exit(0);
}

w_test() 
/* write test */
{
    long n_blocks = 0L;
    extern int sigalarm;

    sync();
    sleep(5); /* to insure the sync */

    signal(SIGALRM,stop_count);
    sigalarm = 0; /* reset alarm flag */
    alarm(seconds);
    while(!sigalarm)
	{
	if (write(f, buf, BUFF_SIZE) <= 0)
	    {
            if (errno != EINTR) {
	        perror("fstime: write");
	        return(-1);
                } else stop_count();
	    }
	++ n_blocks;
        }
    /* stop clock */
    fprintf(stderr, "%ld Kbytes/sec write (%d second sample)\n", 
         (long) n_blocks / (long) seconds, seconds);
return(0);
}

r_test() 
/* read test */
{
    long n_blocks = 0L;
    extern int sigalarm;
    extern int errno;

    /* rewind */
    sync();
    sleep(5);
    lseek(f, 0L, 0);

    signal(SIGALRM,stop_count);
    sigalarm = 0; /* reset alarm flag */
    alarm(seconds);
    while(!sigalarm)
	{
	if (read(f, buf, BUFF_SIZE) <= 0)
	    {
            if (errno == EINVAL) {
                lseek(f, 0L, 0);  /* rewind at end of file */
            } else {
                if (errno != EINTR) {
                   perror("fstime: read");
	           return(-1);
                   } else stop_count();
	        }
            }
	++ n_blocks;
        }
    /* stop clock */
    fprintf(stderr, "%ld Kbytes/sec read (%d second sample)\n", 
         (long) n_blocks / (long) seconds, seconds);
return(0);
}


c_test() 
/* copy test */
{
    long n_blocks = 0L;
    extern int sigalarm;

    /* rewind */
    sync();
    sleep(5); /* to insure the sync */
    lseek(f, 0L, 0);

    signal(SIGALRM,stop_count);
    sigalarm = 0; /* reset alarm flag */
    alarm(seconds);
    while(!sigalarm)
	{
	if (read(f, buf, BUFF_SIZE) <= 0)
	    {
            if (errno == EINVAL) {
                lseek(f, 0L, 0);  /* rewind at end of file */
            } else {
                if (errno != EINTR) {
                    perror("fstime: read");
	            return(-1);
                    } else stop_count();
	        }
            }
	if (write(g, buf, BUFF_SIZE) <= 0)
	    {
            if (errno != EINTR) {
	        perror("fstime: write in copy");
	        return(-1);
                } else stop_count();
	    }
	++ n_blocks;
        }
    /* stop clock */
    fprintf(stderr, "%ld Kbytes/sec copy (%d second sample)\n", 
         (long) n_blocks / (long) seconds, seconds);
return(0);
}

stop_count()
{
extern int sigalarm;
sigalarm = 1;
return(0);
}

clean_up()
{
unlink(f);
unlink(g);
return(0);
}
