###############################################################################
#  The BYTE UNIX Benchmarks - Release 2
#          Module: fs.awk   SID: 2.5 4/17/90 16:45:40
#          
###############################################################################
# Bug reports, patches, comments, suggestions should be sent to:
#
#	Ben Smith or Rick Grehan at BYTE Magazine
#	ben@bytepb.UUCP    rick_g@bytepb.UUCP
#
###############################################################################
#  Modification Log:
#       added geometric mean 8/6/89 -ben
#       modified for new version of fstime 11/15/89
#
###############################################################################
BEGIN   { w_product = 0.0000;
	r_product = 0.0000;
	c_product = 0.0000;
	iter=0;
	w_too_quick=0;
	r_too_quick=0;
	c_too_quick=0;
	}
/real/	{ iter++; ok++; next; }
/user/	{ next; }
/sys/	{ next; }
/^$/	{ next; } 
/fstime/ {
         print "** Iteration ",iter," Failed: ",$0; 
	 ok--;
         fail=1;
         } 
/write/ { if (!fail) {
	       w+=$1;
	       w2+=$1*$1;
	       w_product += log($1); 
	       }
        }
/read/  { if (!fail) {
	       r+=$1;
	       r2+=$1*$1;
	       r_product += log($1); 
	       }
        }
/copy/  { if (!fail) {
	       c+=$1;
	       c2+=$1*$1;
	       c_product += log($1);
	       }
	}
END {
	if (ok != iter) {
	   printf "For %d successful iterations from %d attempts ...\n",ok,iter;
	}
	if (ok > 0) {
	    printf "                       Arithmetric        Geometric         Variance\n";
	    printf "                              Mean             Mean         (%d tests)\n",ok
	    printf "Read (Kbytes/sec):        %9.0f        %9.0f         ",r/ok,exp(r_product/ok);
	    if (ok > 1) printf "%9.2f\n",(r2-r*r/ok)/(ok-1);
	    else printf "n/a\n"
	    printf "Write (Kbytes/sec):       %9.0f        %9.0f         ",w/ok,exp(w_product/ok);
	    if (ok > 1) printf "%9.2f\n",(w2-w*w/ok)/(ok-1);
	    else printf "n/a\n"
	    printf "Copy (Kbytes/sec):        %9.0f        %9.0f         ",c/ok,exp(c_product/ok);
	    if (ok > 1) printf "%9.2f\n",(c2-c*c/ok)/(ok-1);
	    else printf "n/a\n"
	} else {
	    print "-- no measured results --"
	}
    }
