

/*******************************************************************************
 *  The BYTE UNIX Benchmarks - Release 2
 *          Module: clock.c   SID: 2.4 4/17/90 16:45:32
 *          
 *******************************************************************************
 * Bug reports, patches, comments, suggestions should be sent to:
 *
 *	Ben Smith or Rick Grehan at BYTE Magazine
 *	bensmith@bixpb.UUCP    rick_g@bixpb.UUCP
 *
 *******************************************************************************
 *  Modification Log:
 *  $Header: clock.c,v 5.2 87/12/09 14:42:34 kenj Exp $
 *
 ******************************************************************************/
char SCCSid[] = "@(#) @(#)clock.c:2.4 -- 4/17/90 16:45:32";
/*
 *  clock -- check alarm signal accuracy
 *
 */

#include <signal.h>
#include <stdio.h>
#include <sys/types.h>
#ifdef BSD4v1
#include <sys/timeb.h>
#endif
#ifdef BSD4v2
#include <sys/time.h>
#endif
#ifdef SysV
#include <sys/times.h>
#include <sys/param.h>
long	times();
#ifdef interdata
#define HZ tbuffer.tms_cfreq
#endif
#ifndef HZ
	On your system, what is the value of HZ for high resolution elapsed
	time as returned by times() or its equivalent?
#endif
#endif

#define GRANULE		5
#define NUM_ALRM	12

main(argc, argv)
int	argc;
char	*argv[];
{
    int			onalarm();
    register int	i = 0;
    int			expected;
    float		wallclock;
    long		then;
#ifdef SysV
    struct tms		tbuffer;
#endif
#ifdef BSD4v1
    struct timeb	tbuf;
    int			msec;
#endif
#ifdef BSD4v2
    struct timeval	tval;
    struct timezone	tzone;
    long		usec;
#endif

#ifdef SysV
    then = times(&tbuffer);
#else
#ifdef BSD4v1
    ftime(&tbuf);
    then = tbuf.time;
    msec = tbuf.millitm;
#else
#ifdef BSD4v2
    gettimeofday(&tval, &tzone);
    then = tval.tv_sec;
    usec = tval.tv_usec;
#else
	What sort of Unix system is this?
#endif
#endif
#endif
    while (i++ < NUM_ALRM) {
	    signal(SIGALRM, onalarm);
	    alarm(GRANULE);
	    pause();
    }
#ifdef SysV
    wallclock = (times(&tbuffer) - then)/HZ;
#endif
#ifdef BSD4v1
    ftime(&tbuf);
    wallclock = tbuf.time - then + (float)(tbuf.millitm - msec)/1000;
#endif
#ifdef BSD4v2
    gettimeofday(&tval, &tzone);
    wallclock = tval.tv_sec - then + (float)(tval.tv_usec - usec)/1000000;
#endif
    expected = GRANULE * NUM_ALRM;
    printf("%d x %d sec delays takes %.2f wallclock secs (error %.2f%%)\n",
	NUM_ALRM, GRANULE, wallclock, 100.0*(float)(expected-wallclock)/expected);
    exit(0);
}

onalarm() { }
