###############################################################################
#  The BYTE UNIX Benchmarks - Release 2
#          Module: BSDtime.awk   SID: 2.3 4/17/90 16:45:40
#          
###############################################################################
# Bug reports, patches, comments, suggestions should be sent to:
#
#	Ben Smith or Rick Grehan at BYTE Magazine
#	ben@bytepb.UUCP    rick_g@bytepb.UUCP
#
###############################################################################
#  Modification Log:
#     added geometric mean 8/6/89 -ben
#
###############################################################################
BEGIN   { r_product = 0.0000; s_product = 0.0000; u_product = 0.0000; }
/real/	{ if (!fail) {
	    real+=$1;
	    r2+=$1*$1;
	    user+=$3;
	    u2 += $3*$3;
	    sys+=$5;
	    s2 += $5*$5;
	    if($1) { r_product += log($1); }
	    if($1) { u_product += log($3); }
	    if($1) { s_product += log($5); }
	    ok++
	  }
          iter++; fail=0; next;
	}
	{ print "** Iteration ",iter+1," Failed: ",$0; fail=1 }
END {
	if (fail) iter++;
	if (ok != iter) {
	    printf "For %d successful iterations from %d attempts ...\n",ok,iter
	    iter=ok
	}
	if (ok > 0) {
	    printf "                       Arithmetric        Geometric         Variance\n";
	    printf "                              Mean             Mean         (%d tests)\n",ok
	    printf "User Time (secs):        %9.2f        %9.2f         ",user/ok,exp(u_product/ok);
	    if (ok > 1) printf "%9.2f\n",(u2-user*user/ok)/(ok-1);
	    else printf "n/a\n"
	    printf "System Time (secs):      %9.2f        %9.2f         ",sys/ok,exp(s_product/ok);
	    if (ok > 1) printf "%9.2f\n",(s2-sys*sys/ok)/(ok-1);
	    else printf "n/a\n"
	    printf "Real Time (secs):        %9.2f        %9.2f         ",real/ok,exp(r_product/ok);
	    if (ok > 1) printf "%9.2f\n",(r2-real*real/ok)/(ok-1);
	    else printf "n/a\n"
            }
	else printf "-- no measured results --\n "
	}
