.PH
\" this guide should be runoff using the mm macros
\"
\" set the T/C depth
.nr Cl 3
\" set the paragraph indent
.nr Pi 2
\" begin section macro
.de BS
.bp
.PF "''\\$1''"
.OF "'rev 1.19 - 11/9/88'For zoo 2.01'Page %'"
.EF "'page %'For zoo 2.01'rev 1.19 - 11/9/88'"
..
.ls 2
\" This is the way to highlight the name zoo, when in text
.ds z \\fIzoo\\fR
.if n .ds co "(c)
\" This is how to call in constant width fonts on troff
.if t .cs H 22
.de CW
.ie '\\$1'' .ft H
.el \\fH\\$1\\fR
..
.de CE
.ft R
..
\&
.sp 3i
.ce 4
\s+6The \fIzoo\fR Archiver
User's Guide\s-6
Bill Davidsen
.sp
rev 1.19, modified 11/9/88
.sp 1i
.ce
Copyright \*(co 1988 by Bill Davidsen, all rights reserved.
.bp
.P
This document may be distributed unmodified by anyone for any purpose.
Copies of this guide may be freely duplicated and distributed in any
form but may not be sold at a profit.
.sp
.B Trademarks
.P
MS-DOS is a trademark of Microsoft, UNIX is a trademark of AT&T, and
ARC is a trademark of System Enhancement Associates. VMS and VAX are
trademarks of Digital Equipment Corp.
.de PX		\" set binding margins here
.if o .po 1i
.if e .po .5i
..
.pn 1
.BS "Introduction
.H 1 Introduction
.H 2 "What's an archiver, and why do I want one?
.P
.IX "archive
.IX "introduction
.IX "MS-DOS
.IX "UNIX
.IX "compress
.IX "SQ
.IX "LBR
An archive program is one which performs two functions; to compress the
data for a file, such as MS-DOS\*(Tm SQ, or UNIX\*(Tm compress, and to
allow storage of a number of files in a single file, such as MS-DOS LBR
or UNIX tar or cpio.
.P
Because many files have been stored as a single file they can be easily
moved or backed up to another disk or tape. The compressed files take
less space on disk than the originals, and access to other files may be
faster since the directory will be less cluttered.
.H 2 "What's zoo?
.P
\*z is an archive program written by Rahul Dhesi, which offers all of
these benefits, and which also offers your choice of a \fInovice\fR
or an \fIexpert\fR user interface. Additional support programs are
available for MS-DOS, UNIX, and several other systems.
.H 2 "How to use this guide
.P
The User's Guide is not intended to replace the manual. The manual is
concise and complete, but not in many cases easy to use and understand.
The User's Guide is intended to be easy to use and understand, with
examples allowing a new user to learn the use of \*z without
instruction.
.P
This guide is organized by function. If you want to add a file to an
archive, for instance, you go to the "add file" section and read about
how to do it. The simplest case is presented first, followed by
discussion of options and related topics.
.ne 6
.P
\*z provides the following capabilities:
\fBadd\fR files to an archive, \fBextract\fR files from an archive,
\fBlist\f the files in an archive,
\fBdelete\fR files from an existing archive,
and \fBreplace\fR old files with a newer version. All of these basic
functions are available with options.
Details on how to use each of these follows.
.H 1 "Using \*z
.P
.IX "novice commands
.IX "expert commands
\*z has two sets of commands, the \fInovice\fR commands and
\fIexpert\fR commands. The \fInovice\fR commands are easy to learn and
use, and allow you to do the common archiver commands. The \fIexpert\fR
commands are somewhat more complex to use, and provide access to all of
the capabilities of \*z, particularly those which are not available in
most other archivers. Note that you can get a reminder of the novice
commands just by typing the \*z command with no arguments, or the
expert commands by typing "zoo\ h".
.H 2 "Filenames
.H 3 "The name of the archive file
.P
.IX "archive filename
Since \*z is going to take a number of files and place them in one
archive file, there the name of the archive file must be specified. \*z
archives are usually named something.zoo, just as ARC\*(Tm files are named
something.arc, etc. However, the archives may have other names,
depending on the operating system. If the archive name specified by the
user contains at least one dot (.) the suffix zoo will not be added.
.P
When you provide the name of an archive on the command line, if the
name does not contain a dot the extension ".zoo" will be added. This
means that if you use the name "docs" the actual archive will be named
"docs.zoo", while if you use the name "my.doc" that will be the actual
filename. Using names which don't end in .zoo may cause you confusion,
and should be done only when you will still be able to identify the file
as a \*z archive.
.H 3 "The names of files in the archive
.P
.IX "filename limitations
.IX "limitations, filename
The names of files in an archive are limited only by the operating
system. Under MS-DOS the names are eight characters for the name,
followed by a dot, followed by three characters for the extension.
Under VMS\*(Tm the name and extension may each be up to 32 characters
long, and under UNIX the names may be as long as the system allows
(always at least 14 characters) and may be any legal name. Other
operating systems may have other rules for filenames. In general files
with names consisting of not more than 8 characters, a dot, and not
more than three characters are supported by most common operating
systems.
.H 3 "Treatment of wildcards
.P
.IX "wildcards
If you are familiar with the way the UNIX operating system expands
wildcard names, you understand how zoo treats wildcards. For MS-DOS
users the action is most similar to the DIR command, rather than the
COPY usage.
.ne 6
If you type "a*" it means "all names beginning with a" even
if they have an extension. Also, the construct "*a" will match all
filenames ending in "a", such as "data" or "left.pa". 
For a complete discussion see the manual.
.BS "zoo commands
.H 1 "Common zoo operations
.H 2 "Adding data to an archive
.P
.IX "adding file to an archive
.IX "-add command, add files
.IX "a command, add files
When you add a file to an archive, a copy of the file is placed in the
archive in a compressed format. The original file is left unchanged for
other use. The simplest way to add data to an archive is with the
novice command:
.ti +.5i
.CW "zoo -add zoofile myfile
.sp
Which compresses the file \fImyfile\fR and adds it to \fIzoofile.zoo\fR.
You can have several files named on the command line, either explicitly
or with wildcards.
.DS
.nf
Add files examples:
.in +.5i
.CW "zoo -add zoofile myfile.dat myfile.doc
.sp
.CW "zoo a zoofile myfile.*
.DE
.P
Note that if there is already a file in the archive having the same
name as a file you are adding, it will be replaced by the new file. If
you want to prevent this, there is an expert option 'n' which says only
add files which are not in the archive already. 
.DS
For example the two command sequence:
.in +.5i
.nf
.CW
zoo a arch myfile.src
zoo an arch myfile.dat myfile.src myfile.doc
.CE
.DE
.P
.IX "n option, add new files only
Note that the file "myfile.src" was added to the archive with the first
command, and therefore will not be added by the second.
.H 3 "Updating files in an archive
.P
.IX "updating files
.IX "-freshen command, update existing files
.IX "u option, update existing files
There may be times when you want to be sure the archive contains the
latest versions of all the files, without adding any new files. This may
be done with the '-freshen' novice command, or the
option, 'u', controls this in the expert mode.
.DS
You may enter the command as either:
.ti +.5i
.CW "zoo au arch myfiles.*
.br
- or -
.ti +.5i
.CW "zoo -freshen arch myfiles.*
.DE
.sp
where any file which had been changed would be replaced with the newer
version, while any files which were not in the archive would be ignored.
.H 3 "Adding only new files to an archive
.P
.IX "adding new files only
.IX "new files, adding
.IX "n option, add new files
If you want to add some new files to an archive, but don't want to
change the existing files in the archive, even if they are not the
latest version, you can specify leaving the existing files unchanged by
use of the 'n' option in expert mode.
.DS
In expert mode only:
.ti +.5i
.CW "zoo an arch myfiles.*
.DE
will do just that. If a file is in the archive it is not changed, but if
it's not in the archive it will be added.
.H 3 "Bringing an archive up to date
.P
.IX "-update command, add new or changed files
.IX "aun command, add new or changed files
When keeping the parts of a package in a zoo archive, one of the common
operations is to move all newly created files into the archive, and to
update the files which are in the archive but have been modified since
they were saved.
.DS
The easiest way is with the novice command:
.ti +.5i
.CW "zoo -update arch myfiles.*
.br
and can also be done with the expert command:
.ti +.5i
.CW "zoo aun arch myfiles.*
.DE
.P
.IX "-freshen
.IX "-update
Note the difference between '-freshen' and '-update'. The freshen
command does not add new files to the archive, it just insures that the
file already in the archive are the latest versions. The '-update'
command makes sure that the archive contains all of the files you need.
.P
The reason for not using update in all cases is that you may have a lot
of files with unrelated names in a directory, and want to save only a
few. The freshen command allows you to specify all the files in the
directory, and have \*z select those which should be saved.
.DS
To do this you can type:
.ti +.5i
.CW "zoo -freshen arch *
.DE
.H 3 "Moving files into an archive
.P
.IX "-move command, move files into archive
.IX "M option, move files into archive
.IX "delete after archiving
Since one common reason for using an archive is to save space,
frequently you will want to put files into a archive, and then delete
the original, full size, files.
.DS
The novice command to do this is:
.ti +.5i
.CW "zoo -move arch file1 file2
.br
or using the the 'M' option to the 'a' expert command:
.ti +.5i
.CW "zoo aM arch file1 file2
.DE
In either case the original files will not be deleted until \fIall\fR
files have been added to the archive and the archive has been closed.
.H 2 "Listing the archive contents
.P
A \*z archive may be listed, giving the contents of the archive with
various detail and options. A complete list of options is found in the
User's Manual.
.H 3 "Getting a default listing
.DS
.IX "-list command, default format file listing
The common listing is done by:
.ti +.5i
.CW "zoo -list arch
.nf
.sp
Which might produce a listing like:
.sp
.in +.5i
.CW
Archive FIZsim.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    3849  43%     2211   3 Feb 88 21:55:56   69e7   fiz.1
    6864  48%     3563   3 Feb 88 21:52:16   d14e   fiz.c
--------  --- --------  --------- --------
   10713  46%     5774     2 files
.CE
.DE
.P
.IX "listing details
.IX "reading a listing
Let's look at the listing. The first line is the name of the archive,
followed by the line giving the headers for all of the columns. The
first column contains the original length of the file before
compression, the second the percent of compression, and the third the
size of the file in the archive. Remember that the checksum, date, and
the filename are there, too.
.P
Column four is the date when the file was last modified, and five is the
time. The sixth column contains the checksum, discussed in the concepts
section. Finally the name of the file is displayed, either as just a
filename or as a complete name if a subdirectory was specified when the
file was saved.
.P
.IX "totals line
The totals line gives the total of all file sizes, useful when you check
to see if you have room to unpack, the average percent compression, and
the compressed file size. At the end of the totals is the number of
files displayed. Remember that the file count is files displayed, and
may not include all of the files in the archive (see the concepts
section on deleted files and generations).
.H 3 "list files, expert command
.P
.IX "l command, list archive contents
.IX "f option, fast listing
.IX "q option, list without headings
.IX "headings, list without, q option
The expert form of the list command allows a short form of the listing,
having no checksum information displayed. It is otherwise identical to
the the display produced by the -list command. If the 'f' option is
used, only the filenames are displayed, with several filenames on a
line. If you use the 'q' (quiet) option, all of the headings and totals
are deleted as well.
.DS
Using an archive with a number of files, we see this.
.nf
.sp
.in +.5i
.CW
Archive FIZbig.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
     455   4%      438  17 Aug 88 14:12:36     addbfcrc.o
    1280  24%      970  17 Aug 88 14:12:52     addfname.o
    1069  16%      900  17 Aug 88 14:13:02     basename.o
    3509  26%     2611  17 Aug 88 14:13:28     comment.o
     814   0%      814  17 Aug 88 14:13:34     crcdefs.o
    3655  26%     2717  17 Aug 88 14:22:02     fiz.o
     792  13%      688  17 Aug 88 14:13:44     getfile.o
    2465  20%     1972  17 Aug 88 14:14:02     lzc.o
    2543  18%     2082  17 Aug 88 14:14:22     lzd.o
--------  --- --------  --------- --------
   16582  20%    13192     9 files
.CE
.DE
.DS
.nf
.sp
By using the 'f' option we get:
.sp
.in +.5i
.CW
Archive FIZbig.zoo:
addbfcrc.o      addfname.o      basename.o      comment.o       crcdefs.o
fiz.o           getfile.o       lzc.o           lzd.o           
.CE
.DE
.sp
.DS
.nf
If we add the 'q' option to delete the summary:
.sp
.in +.5i
.CW
addbfcrc.o      addfname.o      basename.o      comment.o       crcdefs.o
fiz.o           getfile.o       lzc.o           lzd.o           
.CE
.DE
.P
You may also want to read the section on advanced listing, which
includes a section on keeping track of several archive, including how to
build a rudimentary database of which files are in which archives.
.H 2 "Extracting files from your archive
.H 3 "Unpacking an entire archive
.P
.IX "-extract command, extract for archive
.IX "x command, extract from archive
.IX "extract file from archive
If you want to extract all of the files in an archive to their original
size and date, you can use the novice '-extract' command, or the expert
'x' command.
.DS
.nf
Novice and expert unpack archive:
.in +.5i
.CW "zoo -extract arch
.sp
.CW "zoo x arch
.DE
In both cases all files will be extracted.
.H 3 "Unpacking selected files from an archive
.P
.IX "extracting selected files
If you wish to extract a single file from an archive, you simply add the
file name to the command line after the archive name. The effect is
identical.
.DS
.nf
Extract individual file or files
.in +.5i
.CW
zoo -extract arch myfile.3
.sp
zoo x arch myfile.3
.sp
zoo x arch myfile.3 myfile.4
.sp
zoo x arch *.bas
.CE
.DE
The first two examples do the same thing, using the novice and expert
commands respectively. In the third example several of files are being
extracted at the same time. The use of wildcards is also permitted, as
shown in the fourth example. this will extract all BASIC files from the
archive. The example is for MS-DOS, UNIX and other users should see the
discussion of wildcards and the manual for additional discussion of
this.
.H 2 "Deleting files
.P
.IX "deleting files
When a file is "deleted" from an archive, it is marked as no longer
wanted. If you are using the novice commands the file will be
physically removed from the archive after the delete command has been
executed, and a copy of the archive with the file marked deleted but
still physically in the archive will be called something.bak. If your
archive were called docs.zoo, the backup would be called docs.bak. The
expert commands allow you to leave deleted files in the archive, until
you explicitly remove them with the pack command.
.IX "-delete command, delete files
.IX "D command, delete files
Files are deleted from an archive using the "-delete" novice command or
the "D" expert command.
.DS
.nf
Consider the archive below:
.sp
.in +.5i
.CW
Archive FIZ.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    3849  43%     2211   3 Feb 88 21:55:56     fiz.1
    6864  48%     3563   3 Feb 88 21:52:16     fiz.c
    3849  43%     2211   6 Sep 88 09:33:54     t1/fiz.1
--------  --- --------  --------- --------
   14562  45%     7985     3 files
.CE
.DE
.DS
.nf
If you delete a file and list using the novice command:
.sp
.CW
.in +.5i
zoo -delete FIZ fiz.c
zoo l FIZ
.sp
Archive FIZ.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    3849  43%     2211   3 Feb 88 21:55:56     fiz.1
    3849  43%     2211   6 Sep 88 09:33:54     t1/fiz.1
--------  --- --------  --------- --------
    7698  43%     4422     2 files
.CE
.DE
.DS
.nf
While if I use the expert commands:
.CW
.sp
.in +.5i
zoo D FIZ fiz.c
zoo l FIZ
.sp
Archive FIZ.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    3849  43%     2211   3 Feb 88 21:55:56     fiz.1
    3849  43%     2211   6 Sep 88 09:33:54     t1/fiz.1
--------  --- --------  --------- --------
    7698  43%     4422     2 files
------------
There is 1 deleted file.
.CE
.DE
.P
In addition to the explicit delete command, files are deleted when
overwritten with various forms of the add, freshen, and update
commands.
.BS "Advanced features and commands
.IX "advanced concepts
.H 1 "Other concepts
.H 2 "Packing the archive and deleted files
.P
.IX "packing archives
When a file in an archive is replaced by a newer version of the file, or
another file by the same name, the old version is marked "deleted," but
is still in the archive.
.DS
.IX "d option, list deleted files
You can see deleted files by:
.ti +.5i
.CW "zoo ld arch
.DE
which will list the contents of arch.zoo including deleted files. \*z
has a number of commands and option which allow you to extract deleted
files. The better way to access old versions is to use "generations,"
discussed in the following section.
.P
The deleted files make the archive larger, and therefore should be
removed when you are sure you no longer need them. Since packing the
archive takes time, you may want to perform all of the add and delete
commands on an archive, then pack it.
.P
.IX "deleted files, novice packing
When using the novice commands the archive is packed after every
operation which produces deleted files. The old archive with the deleted
files is saved as file.bak. The backup name is formed by deleting the
last (rightmost) portion of the name and adding .bak. This means that
"myfile.zoo" would have a backup called "myfile.bak", and "my.test.file"
would have a backup names "my.test.bak". Obviously systems which only
allow one '.' in a name don't have all of the forms.
.P
.IX "P command, pack archive
.IX "P option, pack after executing command
While the novice commands pack the file automatically, the expert
commands allow you to control when you will pack the archive. This is
done by the 'P' command, or the 'P' option to most other commands which
may delete files.
.DS
Example - add files and pack:
.ti +.5i
.CW "zoo aP arch file1 file2
.sp
Example - delete files and pack:
.ti +.5i
.CW "zoo dP arch part1.old
.sp
Example - update archive and pack:
.ti +.5i
.CW "zoo aunP arch mystuff.*
.br
or, since the novice commands pack every time
.ti +.5i
.CW "zoo -update arch mystuff.*
.DE
.H 2 "Generations
.P
.IX "generations
There are times when you might want to save an old version of a file,
even though you are working with a newer version. This allows you to
"fall back" if you find a problem. Rather than using the term 'version,'
.IX "VMS
\*z uses the VMS term 'generations.' Normally only one generation of a
file is saved in an archive.
.P
.IX "generations, enabling
.IX "+ option, enable generations
To allow generations to be used with an archive, first they must be
enabled for the archive. This is usually done when the archive is
created, by adding the option '+' to the 'a' command. To determine how
many generations are to be saved, the "generation limit" must be set. If
you want to save just the version of a file previous to the current
version, you can set the limit to one. If you want the last four
versions, the generation limit should be four, etc.
.P
.IX "generation limit setting
The limit may be set using one of two methods, or both if needed. The
first is to set the limit on the entire archive. For instance, if you
set the archive limit to three, the current version and two most recent
versions of each file will be saved.
.DS
.nf
Create the file with generations enabled:
.ti +.5i
.CW "zoo a+ arch file1 file2
.sp
Set the limit for the archive to three:
.ti +.5i
.CW "zoo glA=3 arch
.DE
Now every time you save a file, up to two previous versions will be
saved. If there are already three versions saved, the oldest version
will be deleted. Look at the listing of a archive which has multiple
versions saved.
.DS
.nf
Sample of an archive with generations:
.sp
.in +.5i
.CW
Archive FIZ.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    3849  43%     2211   3 Feb 88 21:55:56     fiz.1;1
      29   0%       29   2 Sep 88 17:31:16     xxx;2
      29   0%       29   2 Sep 88 17:32:06     xxx;3
      29   0%       29   2 Sep 88 17:32:42     xxx;4
--------  --- --------  --------- --------
    3936  42%     2298     4 files
------------
There is 1 deleted file.
.CE
.DE
.P
Note that there are three different version of the file "xxx" in the
archive. Also note that there is one deleted file. This happens to be
the first version of "xxx" which was deleted when version four was
added.
.P
.IX "generations, listing
Now, what if you want generations on just one file, or different limits
on some files? In that case you can set a limit on any file or group of
files which will override the limit set on the archive. You may also
display the limit using the 'g' option for list.
.P
Here's an example based on the previous archive. What you see is the
list with generation information, the command to change it, adding a new
file, and the listing after the file has been added.
.DS
.nf
.in +1i
.ti -1i
Add the next file
.ti -.5i
.CW
zoo a FIZ fiz.1
Zoo:  fiz.1 --  (43%) added
.CE
.sp
.ti -1i
Reset the generation limit for that file
.ti -.5i
.CW
zoo gl=1 FIZ fiz.1
Zoo:  fiz.1;1        -- adjusted to 1
.ti -.5i
zoo Ldg FIZ
.sp
Archive FIZ.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
      29   0%       29   2 Sep 88 17:32:42    0g  D xxx;1
      29   0%       29   2 Sep 88 17:47:14    0g    xxx;2
      29   0%       29   2 Sep 88 17:47:22    0g    xxx;3
      29   0%       29   2 Sep 88 17:47:30    0g    xxx;4
    3849  43%     2211   3 Feb 88 21:55:56    1g    fiz.1;1
--------  --- --------  --------- --------
    3965  41%     2327     5 files
------------
D: deleted file.
Archive generation limit is 3.
.CE
.DE
.P
Looking at the listing, note that the generation information says the
archive limit is three. Since the limit on the file "xxx" is zero, the
archive default is used. Since the limit on file "fiz.1" is one, there
should be only one version of the file kept. Let's test this.
.DS
.nf
.in +1i
.ti -1i
Add the file twice more and view
.CW
zoo a FIZ fiz.1
Zoo:  fiz.1 --  (43%) replaced+
.sp
zoo a FIZ fiz.1
Zoo:  fiz.1 --  (43%) replaced+
.sp
zoo Ldg FIZ
.sp
Archive FIZ.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
      29   0%       29   2 Sep 88 17:32:42    0g  D xxx;1
      29   0%       29   2 Sep 88 17:47:14    0g    xxx;2
      29   0%       29   2 Sep 88 17:47:22    0g    xxx;3
      29   0%       29   2 Sep 88 17:47:30    0g    xxx;4
    3849  43%     2211   3 Feb 88 21:55:56    1g  D fiz.1;1
    3849  43%     2211   3 Feb 88 21:55:56    1g  D fiz.1;2
    3849  43%     2211   3 Feb 88 21:55:56    1g    fiz.1;3
--------  --- --------  --------- --------
   11663  42%     6749     7 files
------------
D: deleted file.
Archive generation limit is 3.
.CE
.DE
.P
After adding the file several time, note that all generations other than
the most recent have been deleted. This is just what we wanted.
Obviously if you wanted to keep a large number of generations of one
file you could set the archive limit higher and lower the limit of other
files. This is useful, if not convenient.
.H 2 "Directory structures
.P
.IX "using subdirectories
.IX "subdirectories
Most operating systems have a multi-level structure of directories, and
what are known as "subdirectories". \*z offers options about using these
on the add command and the extract command. Normally any directory
information you specify is preserved and available for use when the
files are extracted. By default directory information is saved when a
file is added, but not used when it is extracted. These defaults seem to
represent the most common cases.
.H 2 "Matching of filenames
.P
.IX "subdirectories and wildcards
.IX "wildcards and subdirectories
When \*z examines the filenames on the command line, an unintuitive name
matching paradigm is used. If the name contains a path delimiter, such
.IX "UNIX
.IX "MS-DOS
as '/' in UNIX or '\\' in MS-DOS, only the name as entered is matched.
.DS
.nf
For example:
.ti +.5i
.CW "zoo D arch src/subz.c
.DE
Will require an exact match before the file is deleted. However, if you
just specify a filename without a path delimiter, \fIall\fR files of
that name will be deleted, in any directory.
.DS
.nf
Consider this archive:
.sp
.CW
Archive FIZ.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    3849  43%     2211   3 Feb 88 21:55:56     fiz.1
    6864  48%     3563   3 Feb 88 21:52:16     fiz.c
    3849  43%     2211   6 Sep 88 09:33:54     t1/fiz.1
--------  --- --------  --------- --------
   14562  45%     7985     3 files
.CE
.DE
.P
.IX "subdirectory name matching limitations
There are two files, with different dates, named "fiz.1" and "t1/fiz.1". If
you use the delete command on "t1/fiz.1", only that file will be
deleted. If, however, you use the delete command with the name "fiz.1",
both files of that name will be deleted. Currently there is no way to
delete just the file with no path information. This limitation also
applies to other commands which require specifying names in the archive,
such as list and extract.
.H 2 "Comments
.P
.IX "comments
\*z provides two type of comments, one on files to explain what each
file does, and one on the archive as a whole to explain what's in the
archive. The comment on the entire archive might be something like
"analize heat test data," while individual files might have comments
like "validate data routine," and "plot graphs on printer in graphics
mode." The actual commands used to do this are discussed under adding
and listing data sections.
.H 1 "Advanced command usage
.H 2 "adding data to an archive
.H 3 "Move updated files to an archive
.P
.IX "combining update and move
.IX "update and move, combining
.IX "move, combining and update
While the novice commands support the most common operations, there are
several things which can only be done by the expert commands. One of
these is to update an archive and delete the added files. This is a
combination of the -update and -move commands.
.DS
The expert command to do this is:
.ti +.5i
.CW "zoo aunM arch file1 file2
.DE
.P
Note that this is a combination of options, 'u' to update files which
are newer than what's in the archive, 'n' for new files not in the
archive at all, and 'M' to move the added files to the archive. Files
which are current in the archive will not be replaced, saving time (and
if packing is not done, file space).
.H 3 "Packing as an option to add
.IX "packing while adding files
.IX "adding files and packing
Note that because this is an expert command, the archive is not packed,
and any files replaced will still be in the archive. Adding the 'P'
option to the command causes the archive to be packed, and the unpacked
archive to be saved as 'file.bak'.
.DS
For example:
.ti +.5i
.CW "zoo aunMP arch file1 file2
.DE
will pack the archive "arch.zoo" and leave the unpacked version as
"arch.bak".
.H 3 "Adding files from subdirectories
.P
.IX "adding files from subdirectories
.IX "subdirectories
.IX "subdirectories, adding files from
When files are in subdirectories, one thing you can do is to have a
separate archive for each subdirectory. Using \*z you may also have
files from several subdirectories in anarchive. The following examples
.IX "MS-DOS
.IX "UNIX
shown how this is done using MS-DOS or UNIX.
.DS
.nf
MS-DOS:
.ti +.5i
.CW "zoo a src\\\\* doc\\\\*
.sp
UNIX:
.ti +.5i
.CW "zoo a src/* doc/*
.DE
Note that the only difference is that the '\\' delimiter is used in
MS-DOS instead of the more common '/' used in UNIX. When you list an
archive created this way, the listing looks like this.
.DS
.nf
Subdirectory archive listing
.sp
.in +.5i
.CW
Archive FIZsdir.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    3849  43%     2211   2 Sep 88 14:29:02     doc/fiz.1
    6864  48%     3563   2 Sep 88 14:29:02     src/fiz.c
--------  --- --------  --------- --------
   10713  46%     5774     2 files
.CE
.DE
.IX "subdirectory, extracting files from
.IX "extracting files from subdirectories
There are a number of options for extracting these files, allowing you to
use or ignore the subdirectory information. If you want to create the
archive file without the directory names saved as part of the filename,
the ':' option will allow you to do this. One reason to do this is if
you are going to create an archive from a subdirectory and don't want to
have to change to the directory, or if you know the files will be
extracted in another directory.
.DS
.nf
Creating an archive from a subdirectory:
.ti +.5i
.CW "zoo a: arch src/* src/*
.sp
Gives listing:
.sp
.in +.5i
.CW
Archive FIZsdir.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    3849  43%     2211   2 Sep 88 14:29:02     fiz.1
    6864  48%     3563   2 Sep 88 14:29:02     fiz.c
--------  --- --------  --------- --------
   10713  46%     5774     2 files
.CE
.DE
.H 3 "Getting the list of files from another source
.P
.IX "adding lists of files
.IX "standard input, reading filenames from
.IX "filesnames, reading from standard input
If you're storing a large number of files in an archive, it may be
inconvenient to type in the names of the files each time you work on the
archive. \*z allows you to take the files list from a file using the 'I'
option. This option may be applied to a number of commands, but
typically you use it with the 'a' command when creating a new archive,
or the 'aun' command when updating an archive.
.DS
.nf
Example of file list for a file
.in +.5i
.CW "zoo aI arch < files.lst
.DE
Where the file "files.lst" has been created with a list of the files
you're maintaining in this archive. Since this is a simple text file,
you can create it with an editor, and program, or by typing it in.
.P
If you are on a system which supports pipes between commands, you can
use a program to generate a list and send it into \*z without saving it
in a file. The commands "find" on UNIX and "scan" on MS-DOS are useful.
.DS
.IX "UNIX
.IX "MS-DOS
.nf
.in +.5i
.ti -.5i
File list by pipes - UNIX:
.sp
.CW "find . -type f -mtime -4 -print | zoo aI thisweek
.sp
.ti -.5i
File list by pipes - MS-DOS:
.sp
.CW "scan -R *.doc | zoo aI thisweek
.DE
.H 3 "Adding comments to the archive
.P
.IX "comments, adding
Comments may be the entire archive or on individual files, or both. The
concept is discussed in detail in the "Other Concepts" section. Comments
may be added to a file at the time the file is added to the archive.
This is done by the 'c' option. Here is an example of adding data to and
archive with a comment on each file, then adding a comment to the
archive as a whole.
.DS
.nf
.in +.5i
.CW
zoo ac htanal *.for
.sp
Zoo:  main.for    --  ( 0%) added
[Enter comment for main.for then type /END]
Read four heat treat test results files and prepare a graph on the
dot matrix printer.
/end
Zoo:  plot.for    --  ( 0%) added
[Enter comment for plot.for then type /END]
Convert X,Y data to plot points in 240dpi mode
/end
Zoo:  screen.for  --  ( 0%) added
[Enter comment for screen.for then type /END]
FORTRAN version of curses, handle screen display and buffering.
/end
Zoo:  strings.for --  ( 0%) added
[Enter comment for strings.for then type /END]
String manipulation package
/end
.sp 2
zoo cA htanal
.sp
[Enter archive comment for htanal.zoo then type /END]
Heat treat analysis program, prepare plot of results on the dot
matrix printer
/end
.CE
.DE
.P
The first command adds all of the FORTRAN files to the archive, each
with a comment. A comment is then added to the entire archive which
describes the function of the package. If you want to modify the
comments already in the archive, either file or archive, you may use the
'c' or 'cA' commands. The old comment will be listed, and you may either
type a new comment or just press RETURN to keep the existing comment.
.H 3 "Using generations
.P
.IX "generations
Generations are really useful as a way to keep back versions of
files handy in case you have to roll back, or fix a bug in an older
version. Here's how it works.
.P
.IX "generation limit
There is a limit on the number of generations of a file which will be
kept, set on each individual file, and by default zero. This doesn't
mean that no generations are saved, it means that there's no limit.
There's also a limit on the whole archive, called the archive limit, and
that's set by default to one. The maximum number of generations saved is
the lower of the two limits for any given file.
.P
There are three ways to set up an archive with generations. The simplest
is to leave the file limits at the default (zero) and set the archive
limit. What you do is to create an archive using the 'a+' command to add
files and turn on generations. Then you use the 'glA=' command to set
the limit on generations for the whole archive.
.DS
It's easier than it sounds, here's an example:
.sp
.nf
.in +.5i
.CW
zoo a+ demo foo1
Zoo:  foo1 --  (67%) added
.sp
zoo glA=3 demo
Archive generation limit is now 3
.CE
.P
.fi
.ft R
Now we have an archive with one generation of files, and no more than
three generations of files to be saved for any file. After changing the
file and adding new versions to the archive, here's what the archive
looks like. Notice that deleted files haven't been removed, to make it
easy to see what's happening.
.sp 2
.nf
.CW
zoo Ldg demo
.sp
Archive demo.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    5074  67%     1690  18 Oct 88 10:36:52    0g  D foo1;1
    5103  67%     1705  18 Oct 88 10:45:10    0g    foo1;2
    5132  67%     1715  18 Oct 88 10:45:14    0g    foo1;3
    5161  67%     1725  18 Oct 88 10:45:20    0g    foo1;4
--------  --- --------  --------- --------
   20470  67%     6835     4 files
------------
D: deleted file.
Archive generation limit is 3.
.CE
.DE
.P
Remember that there are three ways to use generations. The second is if
I have one file which does not require many generations. In that case I
would set the archive generation limit to the value for all the rest of
the files in the archive, and then set the limit on the one file which
needs a special value.
.DS
It would look like this:
.nf
.in +.5i
.CW
zoo a+ demo foo1 foo2 foo3
Zoo:  foo1 --  (67%) added
Zoo:  foo2 --  (21%) added
Zoo:  foo3 --  (77%) added
.sp
zoo glA=5 demo
Archive generation limit is now 5
.sp
zoo gl=2 demo foo2
Zoo: foo2;1          -- adjusted to 2
.CE
.DE
.P
The final way to manage generations is to set the archive limit to zero,
allowing any number of versions as default, and then setting the limit
on each file individually. This is almost never needed, but it does
allow you to control the generation limit of each file completely.
.H 2 "Listing the archive
.H 3 "Generation information
.P
.IX "generations, listing
.IX "listing generations
There are several options which will help you work with generations. The
simplist is to use the 'L' command instead of the 'l'. Here is a simple
archive, listed in two ways.
.DS
.nf
Listed with 'l':
.sp
.in +.5i
.CW
Archive FIZ.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    6864  48%     3563   3 Feb 88 21:52:16     fiz.c;1
      29   0%       29  31 Aug 88 16:29:04     xxx;2
--------  --- --------  --------- --------
    6893  48%     3592     2 files
.CE
.DE
.DS
.nf
Listed with 'L':
.sp
.in +.5i
.CW
Archive FIZ.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    6864  48%     3563   3 Feb 88 21:52:16     fiz.c;1
      29   0%       29  31 Aug 88 16:29:04     xxx;1
      29   0%       29  31 Aug 88 16:29:04     xxx;2
--------  --- --------  --------- --------
    6922  48%     3621     3 files
.CE
.DE
.P
.IX "L command, list all generations
Note that using 'l' only the most current version is displayed, while
if you use 'L' all non-deleted versions are listed.
.P
.IX "g option, list generation limits
.IX "generation limits, listing
If you set limits on generations of individual files, then you will
want to see those limits. The option to do this is 'g', display
generation info. Without that option the archive and file generation
limits will not be displayed, although the 'L' command will display
undeleted versions.
.DS
.nf
An archive with generations, using 'L':
.sp
.in +.5i
.CW
Archive FIZ.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    6864  48%     3563   3 Feb 88 21:52:16     fiz.c;1
      29   0%       29  31 Aug 88 16:29:04     xxx;1
      29   0%       29  31 Aug 88 16:29:04     xxx;2
--------  --- --------  --------- --------
    6922  48%     3621     3 files
.CE
.DE
.DS
.nf
An archive with generations, using 'Lg':
.sp
.in +.5i
.CW
Archive FIZ.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    6864  48%     3563   3 Feb 88 21:52:16    0g   fiz.c;1
      29   0%       29  31 Aug 88 16:29:04    0g   xxx;1
      29   0%       29  31 Aug 88 16:29:04    0g   xxx;2
--------  --- --------  --------- --------
    6922  48%     3621     3 files
------------
Archive generation limit is 3.
.CE
.DE
.H 3 "Listing deleted files
.P
.IX "listing deleted files
.IX "deleted files, listing
.IX "d option, listing deleted files
If you have modified an archive with the expert commands, and have not
yet packed the archive to remove deleted files, you may view those files
using the 'd' option to the 'l' or 'L' commands.
.DS
.nf
This is what the listing looks like with 'L':
.sp
.in +.5i
.CW
Archive FIZsim.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    6864  48%     3563   3 Feb 88 21:52:16     fiz.c
    3849  43%     2211   3 Feb 88 21:55:56     fiz.1
--------  --- --------  --------- --------
   10713  46%     5774     2 files
------------
There is 1 deleted file.
.CE
.DE
.DS
.nf
And this listing used 'Ld':
.sp
.in +.5i
.CW
Archive FIZsim.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    3849  43%     2211   3 Feb 88 21:55:56    D fiz.1
    6864  48%     3563   3 Feb 88 21:52:16      fiz.c
    3849  43%     2211   3 Feb 88 21:55:56      fiz.1
--------  --- --------  --------- --------
   14562  45%     7985     3 files
------------
D: deleted file.
.CE
.DE
.P
Note that the listing without the 'd' option simply informs you of the
number of selected files, while the listing with 'd' shows you the file
information just as it does the undeleted files.
.H 3 "Listing multiple archives
.P
.IX "listing multiple archives
.IX "L command, listing multiple archives
.IX "multiple archives, listing
The command 'L' allows more than one archive to be listed. In fact the
general form allows for any number of archives to be specified, each
affected by the options of the 'L' command. The restriction is that you
can't just list some files, you get a listing of all undeleted files in
all archives.
.DS
.nf
Command "zoo L FIZ FIZsim":
.sp
.in +.5i
.CW
Archive FIZ.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    6864  48%     3563   3 Feb 88 21:52:16     fiz.c;1
      29   0%       29  31 Aug 88 16:29:04     xxx;1
      29   0%       29  31 Aug 88 16:29:04     xxx;2
--------  --- --------  --------- --------
    6922  48%     3621     3 files
.sp
Archive FIZsim.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    6864  48%     3563   3 Feb 88 21:52:16     fiz.c
    3849  43%     2211   3 Feb 88 21:55:56     fiz.1
--------  --- --------  --------- --------
   10713  46%     5774     2 files
------------
There is 1 deleted file.
.CE
.DE
.H 3 "Creating a simple archive database file
.P
.IX "creating archive content listings
.IX "content listsings, creating
.IX "database input files, creating
The 'a' and 'q' options may be used to create a database file which may
be used as input to your favorite database program, or just sorted and
viewed on the screen or paper.
.DS
.nf
Creating a simple files list from several archives:
.sp
.CW
.ti +.5i
zoo Laq FIZ FIZsim
.sp
.in +.5i
    6864  48%     3563   3 Feb 88 21:52:16     FIZ.zoo fiz.c;1
      29   0%       29  31 Aug 88 16:29:04     FIZ.zoo xxx;1
      29   0%       29  31 Aug 88 16:29:04     FIZ.zoo xxx;2
    6864  48%     3563   3 Feb 88 21:52:16     FIZsim.zoo fiz.c
    3849  43%     2211   3 Feb 88 21:55:56     FIZsim.zoo fiz.1
.CE
.DE
the 'a' option causes the name of the archive to be listed on each line,
instead at the start of the listing. The 'q' option suppresses the
headings and summaries, leaving just one line per file.
.P
The eighth field is the archive name, and the ninth is the file name.
The file may be sorted on either of those, or the size, date modified,
etc. Any or all of those fields may be used a indices for a real
database program, if the number of files and archives is large enough to
warrant that.
.H 3 "Listing comments
.P
.IX "listing comments
.IX "comments, listing
An archive is normally listed using the 'l' command, and only the actual
contents are shown. If the 'v' option is added, or if 'v' is used as a
command, the comment at the start of the archive which describes the
package as a whole is displayed. If the 'V' option or command is used,
the comments on individual files are shown as well. Here are examples of
listing an archive, first with just the descriptive archive comment, and
then with the comments on the individual files as well.
.sp
.DS
.nf
.CW
.in +.5i
zoo v htanal
.sp
Archive htanal.zoo:
>> Heat treat analysis program, prepare plot of results
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
      29   0%       29  17 Oct 88 17:23:24   C main.for
      29   0%       29  17 Oct 88 17:23:24   C plot.for
      29   0%       29  17 Oct 88 17:23:24   C screen.for
      29   0%       29  17 Oct 88 17:23:24   C strings.for
--------  --- --------  --------- --------
     116   0%      116     4 files
------------
C: file has attached comment.
.CE
.DE
.sp 2
.DS
.nf
.CW
.in +.5i
zoo V htanal
.sp
Archive htanal.zoo:
>> Heat treat analysis program, prepare plot of results
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
      29   0%       29  17 Oct 88 17:23:24   C main.for
 |Read four heat treat test results files and prepare a graph on the
 |dot matrix printer.
      29   0%       29  17 Oct 88 17:23:24   C plot.for
 |Convert X,Y data to plot points in 240dpi mode
      29   0%       29  17 Oct 88 17:23:24   C screen.for
 |FORTRAN version of curses, handle screen display and buffering.
      29   0%       29  17 Oct 88 17:23:24   C strings.for
 |String manipulation package
--------  --- --------  --------- --------
     116   0%      116     4 files
------------
.CE
.DE
.H 2 "Extracting files
.H 3 "Extracting to a subdirectory
.P
.IX "extracting to a subdirectory
.IX "subdirectory, extracting to
.IX "/ option, extract to subdirectory
Since the \*z default is to save directory information, you may want to
use that information at some time. The default is to extract all files
into the current directory. If the option '/' is added to the expert
extract command, the files will be extracted into their original
directories, \fIif and only if the directories exist\fR. If you want to
create the directories, the '//' option will do that, creating any
needed directories as the files are extracted.
.DS
.nf
Consider the archive:
.sp
.in +.5i
.CW
Archive myarch.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    3849  43%     2211   2 Sep 88 14:29:02     doc/fiz.1
    6864  48%     3563   2 Sep 88 14:29:02     src/fiz.c
--------  --- --------  --------- --------
   10713  46%     5774     2 files
.CE
.sp
.ti -.5i
And the command:
.CW zoo x myarch
.DE
.P
The files "fiz.1" and "fiz.c" will be extracteded in the current directory.
To extract the files in their original directories, the option '//' may
be used.
.DS
.nf
Creating directories and extracting:
.sp
.in +.5i
.CW "zoo x// myarch
.DE
.P
Finally the '/' option extractes files into their original directories if
the directories exist. In the case where some directories exist and
others don't only the files for which you have directories will be
extracted, and you will get a warning for each file not restored.
.H 3 "Extracting quietly
.P
.IX "q command, quiet operation
.IX "quiet extract
The 'q' command may be used with the 'x' command to extract files
without a message for each file. Although most people want a message to
assure them that the file was extracted, this may be useful if the
extract affects a number of files and only the error messages (if any)
are needed.
.H 3 "Using wildcards for extract
.P
.IX "extract using wildcards
.IX "wildcards, extract using
In general wildcards may be used to extract files as well as save them.
However, on some systems where wildcard names are expanded before the
command is executed, it will be necessary to use the correct escape
sequence to prevent the name from being changed.
.DS
.IX "UNIX
.IX "MS-DOS
.nf
Extract on MS-DOS
.sp
.ti +.5i
.CW "zoo x arch *.doc
.sp
Extract on UNIX
.sp
.ti +.5i
.CW "zoo x arch "*.doc"
.DE
Since the UNIX system expands the wildcard names for you, zoo is a
special case, and you must quote the name. Quoting is not needed on
MS-DOS and VMS.
.H 3 "Extracting deleted files
.P
Although careful use of generations will avoid the need to recover the
deleted versions of files, you may at some time have an archive which
contains a deleted file, and wish to recover it. Consider the archive
below.
.DS
.nf
An archive with a deleted file:
.sp
.in +.5i
.CW
zoo ld FIZ
.sp
Archive FIZ.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    3849  43%     2211   3 Feb 88 21:55:56      fiz.1
    6864  48%     3563   3 Feb 88 16:21:36    D fiz.c
    6864  48%     3563   3 Feb 88 21:52:16      fiz.c
    3849  43%     2211   6 Sep 88 09:33:54      t1/fiz.1
--------  --- --------  --------- --------
   21426  46%    11548     4 files
------------
D: deleted file.
.CE
.DE
.P
To make the situation worse, there is also an undeleted file by the same
name. What you need to do is to recover the the older version of the
file which has been deleted. Note that if you had used the novice
version of the add command it would have packed the archive and the
deleted file would be gone. I could be found in the "FIZ.bak" copy of
the archive, however.
.P
.IX "extracting deleted files
.IX "d option, extracting deleted files
The extract command may be used with the 'd' option, which allows \*z to
extract deleted files as well as active files, or the 'dd' option, which
forces extraction of \fIonly\fR deleted files. Since you have an active
file of the same name, you will want the 'dd' option. Don't forget to
delete whatever version of the file is in your current directory, or you
will need to use still more options.
.DS
.nf
Extracting the deleted file:
.sp
.in +.5i
.CW
zoo xdd FIZ fiz.c
Zoo:  fiz.c          -- extracted
.CE
.DE
The message indicates that the deleted version of the file has been
recovered. Note that the generations feature is intended to eliminate
the need to do this type of operation.
.ne 8
.H 3 "Extract and overwrite
.ce
"You are lost in a twisty maze of options, all alike"
.P
.IX "extracting with overwrite
.IX "overwrite files on extract
.IX "O option, overwrite existing files
There are three options which allow you to extract files from an archive
without deleting all of the files in your current directory structure.
These are generally useful only when the existing file have become
damaged in some way, such as trying to make changes to source or
documentation with a new editor, etc.
.P
The 'O' option allows \*z to overwrite existing files. Without this
option \*z will ask permission to overwrite an existing file before
replacing it. While this is useful as a safety measure, there are times
when you will want to "just do it." When the 'O' option is specified,
existing file will be replaced unless they are newer than the file in
the archive or read-only. Using the option "OO" instead of 'O' allows
\*z to overwrite "read-only" files. If you want to replace existing
files you must use one of these two options.
.P
.IX "extracting read-only files
.IX "read-only files, extracting
.IX "S option, overwrite read-only files
.IX "overwriting newer files on extract
Even when using the 'O' option, an existing file will not be overwritten
if it is newer than the version in the archive. This would happen if you
extracted a file, changed it, and then found that the changes were
incorrect. To allow \*z to replace a newer files, you need the option
'S', which specifies that a superseded file will be extracted. The
'SOO" combination of options will cause \*z to extract any file
specified unconditionally.
.H 3 "Extracting generations
.P
.IX "generations, extracting
.IX "extracting generations
If you have an archive with previous generations, at some time you will
want to extract a generation older than the most current. To do this
you specify the generation number as part of the filename in the 'x'
command.
.DS
Let's look at the listing of an archive with generations, and then the
command to extract an old generation:
.sp
.nf
.CW
.in +.5i
zoo Ldg demo
.sp
Archive demo.zoo:
Length    CF  Size Now  Date      Time
--------  --- --------  --------- --------
    5074  67%     1690  18 Oct 88 10:36:52    0g  D foo1;1
    5103  67%     1705  18 Oct 88 10:45:10    0g    foo1;2
    5132  67%     1715  18 Oct 88 10:45:14    0g    foo1;3
    5161  67%     1725  18 Oct 88 10:45:20    0g    foo1;4
--------  --- --------  --------- --------
   20470  67%     6835     4 files
------------
D: deleted file.
Archive generation limit is 3.
.sp 2
zoo x demo foo1;2
Zoo: foo1;2         -- extracted
.CE
.DE
.P
.IX "generation delimiters
Notice that the characters ';' or ':' may be used to separate the
filename from the generation. The ';' is customary in VMS, while it's
inconvenient in UNIX, where the ':' may be used. At this time there's no
way to bypass the generation character and access a file with either
character in its name.
.OP
.ls 1
.H 1 Index
.so uguide.idx
.de PX		\" no offset on these
..
.TC
