//
//      **************************************************************
//       JdeBP C++ Library Routines      General Public Licence v1.00
//          Copyright (c) 1991,1992  Jonathan de Boyne Pollard
//      **************************************************************
//
//  SIGNAL HANDLING (ANSI and POSIX)
//

#if !defined(___STDDEF_H_INCLUDED)
#include <_stddef.h>
#endif

//
//  Action classes (must not be equivalent to any declarable function)
//

#define SIG_DFL     (void (_CDECL *)(int))raise     /* default signal action    */
#define SIG_ERR     (void (_CDECL *)(int))-1        /* signal() error return    */
#define SIG_IGN     (void (_CDECL *)(int))signal    /* ignore signal action     */

#if _POSIX1_SOURCE > 0

//
//  Signal sets (may be an integral or a structure type).
//
#ifndef _SIGSET_T_DEFINED
typedef _Sigset_t sigset_t ;
#define _SIGSET_T_DEFINED
#endif

//
//  Signal actions
//

#ifndef _STRUCT_SIGACTION_DEFINED
struct sigaction {
    void    (_CDECL *sa_handler)(int) ; // Handling function
    sigset_t    sa_mask ;               // Mask during handling
    int         sa_flags ;              // SIGCHLD specific
} ;
#define _STRUCT_SIGACTION_DEFINED
#endif

//
//  How to alter signal sets for sigprocmask()
//
#define SIG_BLOCK   (void (_CDECL *)(int))1
#define SIG_UNBLOCK (void (_CDECL *)(int))2
#define SIG_SETMASK (void (_CDECL *)(int))3

#endif

//
//  Signal numbers (must be positive and less than log2(ULONG_MAX))
//

//
//  Default action is termination or ignore
//
#define SIGABRT     1   /* Abnormal program termination */
#define SIGFPE      2   /* Erroneous arithmetic operation */
#define SIGILL      3   /* Invalid function image */
#define SIGINT      4   /* Interactive attention signal */
#define SIGSEGV     5   /* Invalid access to (internal) storage */
#define SIGTERM     6   /* Program termination request */
#if _POSIX1_SOURCE > 0
//
//  Default action is termination
//
#define SIGALRM     7   /* Timeout */
#define SIGHUP      8   /* Hangup on controlling terminal */
#define SIGKILL     9   /* Forcible termination */
#define SIGPIPE     10  /* Write on broken pipe */
#define SIGQUIT     11  /* Interactive termination signal */
#define SIGUSR1     12  /* User defined 1 */
#define SIGUSR2     13  /* User defined 2 */
//
//  Default action is ignore
//
#define SIGCHLD     14  /* Child process stopped or terminated */
#define SIGCONT     15  /* Continuation */
//
//  Default action is stop the process
//
#define SIGSTOP     16  /* Forcible stop */
#define SIGTSTP     17  /* Interactive stop */
#define SIGTTIN     18  /* Read from tty in background */
#define SIGTTOU     19  /* Write to tty in background */
#endif

#ifndef _SIG_ATOMIC_T_DEFINED
typedef volatile unsigned char sig_atomic_t;
#define _SIG_ATOMIC_T_DEFINED
#endif

extern "C" {

int     _CDECL  raise       (int);
void    (_CDECL * signal    (int, void (_CDECL *)(int)))(int);

#if _POSIX1_SOURCE > 0
int     _CDECL  sigemptyset (sigset_t *) ;
int     _CDECL  sigfillset  (sigset_t *) ;
int     _CDECL  sigaddset   (sigset_t *, int) ;
int     _CDECL  sigdelset   (sigset_t *, int) ;
int     _CDECL  sigismember (const sigset_t *, int) ;

int     _CDECL  sigaction   (int, struct sigaction *, struct sigaction *) ;
int     _CDECL  sigprocmask (int, sigset_t *, sigset_t *) ;
int     _CDECL  sigpending  (sigset_t *) ;

int     _CDECL  sigsuspend  (sigset_t *) ;
#endif

}
